<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$no_faktur_jual = $_GET['no_faktur'];
$invoice_data = null;
$product_details = [];

// Ambil data faktur utama
$stmt_main = $koneksi->prepare("SELECT tj.no_faktur_jual, tj.tgl_transaksi, tj.total_penjualan, tj.status_pembayaran, mp.nama_pelanggan, mp.alamat, mp.email, mp.telepon FROM transaksi_penjualan tj JOIN master_pelanggan mp ON tj.id_pelanggan = mp.id_pelanggan WHERE tj.no_faktur_jual = ?");
$stmt_main->bind_param("s", $no_faktur_jual);
$stmt_main->execute();
$result_main = $stmt_main->get_result();
if ($result_main->num_rows > 0) {
    $invoice_data = $result_main->fetch_assoc();
}
$stmt_main->close();

// Ambil detail produk untuk faktur
if ($invoice_data) {
    $stmt_detail = $koneksi->prepare("SELECT tjd.jumlah_produk, tjd.satuan, tjd.harga_satuan_produk, tjd.harga_total_produk, mpr.nama_produk, mpr.kode_produk, mpr.type_produk, mpr.merk_produk, mpr.kategori_produk FROM transaksi_penjualan_detail tjd JOIN transaksi_penjualan tj ON tjd.id_penjualan = tj.id_penjualan JOIN master_produk mpr ON tjd.id_produk = mpr.id_produk WHERE tj.no_faktur_jual = ?");
    $stmt_detail->bind_param("s", $no_faktur_jual);
    $stmt_detail->execute();
    $result_detail = $stmt_detail->get_result();
    while ($row = $result_detail->fetch_assoc()) {
        $product_details[] = $row;
    }
    $stmt_detail->close();
}

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cetak Faktur Penjualan #<?php echo htmlspecialchars($no_faktur_jual); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .invoice-container {
            max-width: 800px;
            margin: 2rem auto;
            background: #fff;
            padding: 3rem;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        }
        @media print {
            body { background: #fff; }
            .invoice-container { box-shadow: none; margin: 0; padding: 0; max-width: none; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>

    <?php if ($invoice_data): ?>
    <div class="no-print text-center my-4">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-6 rounded-full transition-colors duration-300 shadow-lg">
            Cetak Faktur
        </button>
    </div>
    
    <div class="invoice-container">
        <div class="flex justify-between items-start mb-10">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">FAKTUR PENJUALAN</h1>
                <p class="text-sm text-gray-500">No. Faktur: #<?php echo htmlspecialchars($invoice_data['no_faktur_jual']); ?></p>
            </div>
            <div class="text-right">
                <h2 class="text-xl font-semibold text-gray-700">Sistem Informasi Bisnis</h2>
                <p class="text-sm text-gray-600">Jalan Merdeka No. 123</p>
                <p class="text-sm text-gray-600">Kota Contoh</p>
            </div>
        </div>

        <div class="grid grid-cols-2 gap-8 mb-10 text-sm">
            <div>
                <h3 class="font-bold text-gray-800 mb-2">Pelanggan:</h3>
                <p class="font-semibold"><?php echo htmlspecialchars($invoice_data['nama_pelanggan']); ?></p>
                <p class="text-gray-600"><?php echo htmlspecialchars($invoice_data['alamat']); ?></p>
                <p class="text-gray-600">Tel: <?php echo htmlspecialchars($invoice_data['telepon']); ?></p>
                <p class="text-gray-600">Email: <?php echo htmlspecialchars($invoice_data['email']); ?></p>
            </div>
            <div class="text-right">
                <h3 class="font-bold text-gray-800 mb-2">Detail Transaksi:</h3>
                <p>Tanggal Transaksi: <span class="font-semibold"><?php echo date('d M Y', strtotime($invoice_data['tgl_transaksi'])); ?></span></p>
                <p>Status Pembayaran: <span class="font-semibold"><?php echo htmlspecialchars($invoice_data['status_pembayaran']); ?></span></p>
            </div>
        </div>
        
        <table class="min-w-full leading-normal mb-8">
            <thead>
                <tr class="text-left text-gray-600 uppercase text-xs font-semibold border-b border-gray-200">
                    <th class="py-3 px-2">Kode Produk</th>
                    <th class="py-3 px-2">Nama Produk</th>
                    <th class="py-3 px-2 text-center">Jumlah</th>
                    <th class="py-3 px-2 text-center">Satuan</th>
                    <th class="py-3 px-2 text-right">Harga Satuan</th>
                    <th class="py-3 px-2 text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($product_details as $item): ?>
                <tr class="border-b border-gray-200 text-sm text-gray-800">
                    <td class="py-3 px-2"><?php echo htmlspecialchars($item['kode_produk']); ?></td>
                    <td class="py-3 px-2"><?php echo htmlspecialchars($item['nama_produk']); ?></td>
                    <td class="py-3 px-2 text-center"><?php echo htmlspecialchars($item['jumlah_produk']); ?></td>
                    <td class="py-3 px-2 text-center"><?php echo htmlspecialchars($item['satuan']); ?></td>
                    <td class="py-3 px-2 text-right">Rp <?php echo number_format($item['harga_satuan_produk'], 2, ',', '.'); ?></td>
                    <td class="py-3 px-2 text-right">Rp <?php echo number_format($item['harga_total_produk'], 2, ',', '.'); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="5" class="py-3 px-2 text-right text-lg font-bold text-gray-800">TOTAL FAKTUR</td>
                    <td class="py-3 px-2 text-right text-lg font-bold text-gray-800">Rp <?php echo number_format($invoice_data['total_penjualan'], 2, ',', '.'); ?></td>
                </tr>
            </tfoot>
        </table>

        <div class="mt-10">
            <p class="text-sm text-gray-600">Terima kasih atas pembelian Anda.</p>
        </div>
    </div>
    
    <?php else: ?>
    <div class="invoice-container text-center">
        <h2 class="text-2xl text-red-500 font-semibold">Faktur tidak ditemukan.</h2>
        <p class="mt-2 text-gray-600">Mohon periksa kembali nomor faktur yang Anda masukkan.</p>
        <a href="view_penjualan.php" class="mt-4 inline-block bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded-lg transition-colors">
            Kembali
        </a>
    </div>
    <?php endif; ?>
</body>
</html>
