<?php
session_start();

// Cek apakah user sudah login, jika tidak redirect ke halaman login
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}

// Tambahkan logika otorisasi peran
$user_role = $_SESSION['role'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar {
            background-color: #ffffff;
            box-shadow: 2px 0 10px rgba(0,0,0,0.05);
            transition: width 0.3s ease;
        }
        .sidebar.collapsed {
            width: 80px;
        }
        .sidebar-item {
            display: flex;
            align-items: center;
            padding: 1rem 1.5rem;
            color: #666;
            transition: all 0.2s ease;
            border-radius: 10px;
            margin: 0.5rem 1rem;
        }
        .sidebar-item:hover, .sidebar-item.active {
            background-color: #e2e8f0;
            color: #2c5282;
            transform: translateX(5px);
        }
        .sidebar-item i {
            font-size: 1.25rem;
            width: 25px;
            text-align: center;
        }
        .sidebar-item span {
            margin-left: 1rem;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .logo {
            padding: 1rem;
            text-align: center;
            font-size: 1.5rem;
            font-weight: 700;
            color: #333;
        }
        .content-area {
            background-color: #f9fafb;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        .card-menu {
            background-color: #ffffff;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            text-align: center;
            text-decoration: none;
            color: #333;
        }
        .card-menu:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }
        .card-menu i {
            font-size: 3rem;
            color: #4a5568;
            margin-bottom: 1rem;
        }
        .card-menu h4 {
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <!-- Sidebar -->
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="?page=dashboard" class="sidebar-item active">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <!-- Main Content -->
        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Sistem Informasi Bisnis</h1>
                <div class="flex items-center space-x-4">
                    <span class="text-gray-600">Halo, <?php echo htmlspecialchars($_SESSION['nama_lengkap']); ?></span>
                </div>
            </header>
            
            <div class="content-area">
                <?php
                $page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';
                switch ($page) {
                    case 'dashboard':
                        // Tampilan Dashboard
                        echo '
                        <div class="mb-6">
                            <h2 class="text-2xl font-semibold mb-4">Dashboard</h2>
                            <p class="text-gray-600">Selamat datang di Sistem Informasi Bisnis. Silakan gunakan menu di samping untuk mengelola data Anda.</p>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                            <a href="?page=master_produk" class="card-menu">
                                <i class="fas fa-box"></i>
                                <h4>Master Produk</h4>
                            </a>
                            <a href="?page=master_supplier" class="card-menu">
                                <i class="fas fa-truck"></i>
                                <h4>Master Supplier</h4>
                            </a>
                            <a href="?page=master_pelanggan" class="card-menu">
                                <i class="fas fa-users"></i>
                                <h4>Master Pelanggan</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'pembelian':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Pembelian</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                            <a href="input_pembelian.php" class="card-menu">
                                <i class="fas fa-plus-circle"></i>
                                <h4>Input Pembelian</h4>
                            </a>
                            <a href="view_pembelian.php" class="card-menu">
                                <i class="fas fa-eye"></i>
                                <h4>View Pembelian</h4>
                            </a>
                            <a href="cetak_faktur_beli.php" class="card-menu">
                                <i class="fas fa-print"></i>
                                <h4>Cetak Faktur Beli</h4>
                            </a>
                            <a href="laporan_pembelian.php" class="card-menu">
                                <i class="fas fa-file-invoice"></i>
                                <h4>Laporan Pembelian</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'penjualan':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Penjualan</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                            <a href="input_penjualan.php" class="card-menu">
                                <i class="fas fa-plus-circle"></i>
                                <h4>Input Penjualan</h4>
                            </a>
                            <a href="view_penjualan.php" class="card-menu">
                                <i class="fas fa-eye"></i>
                                <h4>View Penjualan</h4>
                            </a>
                            <a href="cetak_faktur_jual.php" class="card-menu">
                                <i class="fas fa-file-invoice-dollar"></i>
                                <h4>Cetak Faktur Jual</h4>
                            </a>
                            <a href="cetak_surat_jalan.php" class="card-menu">
                                <i class="fas fa-truck-loading"></i>
                                <h4>Cetak Surat Jalan</h4>
                            </a>
                            <a href="laporan_penjualan.php" class="card-menu">
                                <i class="fas fa-chart-bar"></i>
                                <h4>Laporan Penjualan</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'stok':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Stok</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                            <a href="view_stok.php" class="card-menu">
                                <i class="fas fa-boxes"></i>
                                <h4>View Stok</h4>
                            </a>
                            <a href="history_stok.php" class="card-menu">
                                <i class="fas fa-history"></i>
                                <h4>History Stok</h4>
                            </a>
                            <a href="laporan_stok.php" class="card-menu">
                                <i class="fas fa-file-alt"></i>
                                <h4>Laporan Stok</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'retur_pembelian':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Retur Pembelian</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <a href="input_retur_pembelian.php" class="card-menu">
                                <i class="fas fa-undo"></i>
                                <h4>Input Retur Pembelian</h4>
                            </a>
                            <a href="view_retur_pembelian.php" class="card-menu">
                                <i class="fas fa-eye"></i>
                                <h4>View Retur Pembelian</h4>
                            </a>
                            <a href="laporan_retur_pembelian.php" class="card-menu">
                                <i class="fas fa-file-pdf"></i>
                                <h4>Laporan Retur Pembelian</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'retur_penjualan':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Retur Penjualan</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <a href="input_retur_penjualan.php" class="card-menu">
                                <i class="fas fa-undo-alt"></i>
                                <h4>Input Retur Penjualan</h4>
                            </a>
                            <a href="view_retur_penjualan.php" class="card-menu">
                                <i class="fas fa-eye"></i>
                                <h4>View Retur Penjualan</h4>
                            </a>
                            <a href="laporan_retur_penjualan.php" class="card-menu">
                                <i class="fas fa-file-pdf"></i>
                                <h4>Laporan Retur Penjualan</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'utang':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Utang (Account Payable)</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                            <a href="view_utang.php" class="card-menu">
                                <i class="fas fa-hand-holding-usd"></i>
                                <h4>View Utang</h4>
                            </a>
                            <a href="pelunasan_utang.php" class="card-menu">
                                <i class="fas fa-money-bill-wave"></i>
                                <h4>Pelunasan Utang</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'piutang':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Piutang (Account Receivable)</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                            <a href="view_piutang.php" class="card-menu">
                                <i class="fas fa-money-check-alt"></i>
                                <h4>View Piutang</h4>
                            </a>
                            <a href="pelunasan_piutang.php" class="card-menu">
                                <i class="fas fa-credit-card"></i>
                                <h4>Pelunasan Piutang</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'kas_harian':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Kas Harian</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6">
                            <a href="input_kas.php" class="card-menu">
                                <i class="fas fa-wallet"></i>
                                <h4>Input Kas</h4>
                            </a>
                            <a href="view_kas.php" class="card-menu">
                                <i class="fas fa-list-alt"></i>
                                <h4>View Kas</h4>
                            </a>
                        </div>
                        ';
                        break;
                    case 'laba_kotor':
                        // Otorisasi tambahan untuk menu laba kotor
                        if ($user_role == 'admin') {
                            echo '
                            <h2 class="text-2xl font-semibold mb-6">Laba Kotor</h2>
                            <p class="text-gray-600">Menu untuk melihat perhitungan laba kotor.</p>
                            ';
                        } else {
                            echo '<p class="text-red-500">Anda tidak memiliki hak akses ke menu ini.</p>';
                        }
                        break;
                    case 'dss':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Decision Support System</h2>
                        <p class="text-gray-600">Menu ini akan menampilkan grafik dan analitik untuk membantu pengambilan keputusan.</p>
                        ';
                        break;
                    case 'master_produk':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Master Produk</h2>
                        <p class="text-gray-600">Menu ini akan menampilkan semua data produk yang tersedia.</p>
                        ';
                        break;
                    case 'master_supplier':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Master Supplier</h2>
                        <p class="text-gray-600">Menu ini akan menampilkan semua data supplier.</p>
                        ';
                        break;
                    case 'master_pelanggan':
                        echo '
                        <h2 class="text-2xl font-semibold mb-6">Master Pelanggan</h2>
                        <p class="text-gray-600">Menu ini akan menampilkan semua data pelanggan.</p>
                        ';
                        break;
                    default:
                        echo '<h2 class="text-2xl font-semibold mb-6">404 - Halaman Tidak Ditemukan</h2>';
                        break;
                }
                ?>
            </div>
        </main>
    </div>
</body>
</html>
