<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];

// --- Data untuk Grafik ---

// Laporan Penjualan Semua Produk berdasarkan Periode
$penjualan_periode = [];
$sql_penjualan_periode = "
    SELECT DATE_FORMAT(tgl_transaksi, '%Y-%m') AS periode, SUM(harga_total_produk) AS total_penjualan
    FROM transaksi_penjualan
    GROUP BY periode
    ORDER BY periode ASC";
$result_penjualan_periode = $koneksi->query($sql_penjualan_periode);
if ($result_penjualan_periode->num_rows > 0) {
    while ($row = $result_penjualan_periode->fetch_assoc()) {
        $penjualan_periode[] = $row;
    }
}

// Laporan Laba Kotor Semua Produk berdasarkan Periode
$laba_kotor_periode = [];
$sql_laba_kotor_periode = "
    SELECT DATE_FORMAT(tp.tgl_transaksi, '%Y-%m') AS periode, SUM((tpd.harga_satuan - mp.harga_modal) * tpd.jumlah_produk) AS total_laba_kotor
    FROM transaksi_penjualan tp
    JOIN transaksi_penjualan_detail tpd ON tp.id_penjualan = tpd.id_penjualan
    JOIN master_produk mp ON tpd.id_produk = mp.id_produk
    GROUP BY periode
    ORDER BY periode ASC";
$result_laba_kotor_periode = $koneksi->query($sql_laba_kotor_periode);
if ($result_laba_kotor_periode->num_rows > 0) {
    while ($row = $result_laba_kotor_periode->fetch_assoc()) {
        $laba_kotor_periode[] = $row;
    }
}

// Produk paling banyak terjual (Quantity)
$top_produk_qty = [];
$sql_top_produk_qty = "
    SELECT mp.nama_produk, SUM(tpd.jumlah_produk) AS total_qty
    FROM transaksi_penjualan_detail tpd
    JOIN master_produk mp ON tpd.id_produk = mp.id_produk
    GROUP BY mp.nama_produk
    ORDER BY total_qty DESC
    LIMIT 10";
$result_top_produk_qty = $koneksi->query($sql_top_produk_qty);
if ($result_top_produk_qty->num_rows > 0) {
    while ($row = $result_top_produk_qty->fetch_assoc()) {
        $top_produk_qty[] = $row;
    }
}

// Produk yang labanya paling besar
$top_produk_laba = [];
$sql_top_produk_laba = "
    SELECT mp.nama_produk, SUM((tpd.harga_satuan - mp.harga_modal) * tpd.jumlah_produk) AS total_laba
    FROM transaksi_penjualan_detail tpd
    JOIN master_produk mp ON tpd.id_produk = mp.id_produk
    GROUP BY mp.nama_produk
    ORDER BY total_laba DESC
    LIMIT 10";
$result_top_produk_laba = $koneksi->query($sql_top_produk_laba);
if ($result_top_produk_laba->num_rows > 0) {
    while ($row = $result_top_produk_laba->fetch_assoc()) {
        $top_produk_laba[] = $row;
    }
}

// Produk yang besar nominal penjualannya
$top_produk_value = [];
$sql_top_produk_value = "
    SELECT mp.nama_produk, SUM(tpd.harga_total_produk) AS total_nominal
    FROM transaksi_penjualan_detail tpd
    JOIN master_produk mp ON tpd.id_produk = mp.id_produk
    GROUP BY mp.nama_produk
    ORDER BY total_nominal DESC
    LIMIT 10";
$result_top_produk_value = $koneksi->query($sql_top_produk_value);
if ($result_top_produk_value->num_rows > 0) {
    while ($row = $result_top_produk_value->fetch_assoc()) {
        $top_produk_value[] = $row;
    }
}

// Produk yang stoknya hampir habis
$low_stok_produk = [];
$sql_low_stok_produk = "
    SELECT nama_produk, stok FROM master_produk WHERE stok <= 10 ORDER BY stok ASC LIMIT 10";
$result_low_stok_produk = $koneksi->query($sql_low_stok_produk);
if ($result_low_stok_produk->num_rows > 0) {
    while ($row = $result_low_stok_produk->fetch_assoc()) {
        $low_stok_produk[] = $row;
    }
}

// Data untuk dropdown filter
$pelanggan_list = [];
$sql_pelanggan = "SELECT id_pelanggan, nama_pelanggan FROM master_pelanggan ORDER BY nama_pelanggan ASC";
$result_pelanggan = $koneksi->query($sql_pelanggan);
if ($result_pelanggan->num_rows > 0) {
    while ($row = $result_pelanggan->fetch_assoc()) {
        $pelanggan_list[] = $row;
    }
}

$supplier_list = [];
$sql_supplier = "SELECT id_supplier, nama_supplier FROM master_supplier ORDER BY nama_supplier ASC";
$result_supplier = $koneksi->query($sql_supplier);
if ($result_supplier->num_rows > 0) {
    while ($row = $result_supplier->fetch_assoc()) {
        $supplier_list[] = $row;
    }
}

$produk_list = [];
$sql_produk = "SELECT id_produk, nama_produk FROM master_produk ORDER BY nama_produk ASC";
$result_produk = $koneksi->query($sql_produk);
if ($result_produk->num_rows > 0) {
    while ($row = $result_produk->fetch_assoc()) {
        $produk_list[] = $row;
    }
}

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Decision Support System (DSS) - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .chart-container {
            position: relative;
            height: 350px;
            max-height: 400px;
            width: 100%;
        }
        .summary-box {
            background-color: #fff;
            padding: 1.5rem;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            text-align: center;
        }
        .summary-box h3 { font-size: 1.25rem; font-weight: 600; color: #4a5568; }
        .summary-box p { font-size: 2.5rem; font-weight: 700; color: #2c5282; margin-top: 0.5rem; }
        .card {
            background-color: #fff;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=master_produk" class="sidebar-item">
                        <i class="fas fa-cube"></i>
                        <span>Master Produk</span>
                    </a>
                    <a href="dashboard.php?page=master_supplier" class="sidebar-item">
                        <i class="fas fa-truck-loading"></i>
                        <span>Master Supplier</span>
                    </a>
                    <a href="dashboard.php?page=master_pelanggan" class="sidebar-item">
                        <i class="fas fa-users"></i>
                        <span>Master Pelanggan</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item active">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Decision Support System</h1>
            </header>
            
            <div class="content-area">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- Produk Paling Laris (Quantity) -->
                    <div class="card col-span-1">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">10 Produk Paling Laris (Quantity)</h3>
                        <div class="chart-container">
                            <canvas id="chartProdukQty"></canvas>
                        </div>
                    </div>
                    <!-- Produk Laba Paling Besar -->
                    <div class="card col-span-1">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">10 Produk Laba Paling Besar</h3>
                        <div class="chart-container">
                            <canvas id="chartProdukLaba"></canvas>
                        </div>
                    </div>
                    <!-- Produk Nominal Penjualan Paling Besar -->
                    <div class="card col-span-1">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">10 Produk Nominal Penjualan Terbesar</h3>
                        <div class="chart-container">
                            <canvas id="chartProdukValue"></canvas>
                        </div>
                    </div>
                    <!-- Produk Stok Hampir Habis -->
                    <div class="card col-span-1 md:col-span-2 lg:col-span-3">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">Produk dengan Stok Hampir Habis (Stok ≤ 10)</h3>
                        <div class="table-responsive rounded-lg shadow-sm">
                            <table class="table-auto min-w-full bg-white rounded-lg">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3">Nama Produk</th>
                                        <th class="px-6 py-3">Stok</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($low_stok_produk)): ?>
                                        <?php foreach ($low_stok_produk as $row): ?>
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['nama_produk']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 font-semibold text-red-500"><?php echo htmlspecialchars($row['stok']); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="2" class="px-6 py-4 text-center text-gray-500">Semua stok produk aman.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Grafik Penjualan Semua Produk -->
                    <div class="card col-span-1 md:col-span-2">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">Grafik Penjualan Semua Produk (Berdasarkan Bulan)</h3>
                        <div class="chart-container">
                            <canvas id="chartPenjualanPeriode"></canvas>
                        </div>
                    </div>
                    <!-- Grafik Laba Kotor Semua Produk -->
                    <div class="card col-span-1 md:col-span-2">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">Grafik Laba Kotor Semua Produk (Berdasarkan Bulan)</h3>
                        <div class="chart-container">
                            <canvas id="chartLabaKotorPeriode"></canvas>
                        </div>
                    </div>
                    <!-- Grafik Penjualan per Pelanggan -->
                    <div class="card col-span-1 md:col-span-2 lg:col-span-3">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">Grafik Penjualan Berdasarkan Pelanggan</h3>
                        <div class="form-container mb-4 flex flex-col md:flex-row gap-4 items-end">
                            <div class="w-full md:w-1/3">
                                <label for="selectPelanggan" class="block text-sm font-medium text-gray-700">Pilih Pelanggan</label>
                                <select id="selectPelanggan" class="mt-1 block w-full">
                                    <option value="">Pilih Semua Pelanggan</option>
                                    <?php foreach ($pelanggan_list as $pelanggan): ?>
                                    <option value="<?php echo htmlspecialchars($pelanggan['id_pelanggan']); ?>"><?php echo htmlspecialchars($pelanggan['nama_pelanggan']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="chart-container">
                            <canvas id="chartPenjualanPelanggan"></canvas>
                        </div>
                    </div>
                    <!-- Grafik Pembelian per Supplier -->
                    <div class="card col-span-1 md:col-span-2 lg:col-span-3">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">Grafik Pembelian Berdasarkan Supplier</h3>
                        <div class="form-container mb-4 flex flex-col md:flex-row gap-4 items-end">
                            <div class="w-full md:w-1/3">
                                <label for="selectSupplier" class="block text-sm font-medium text-gray-700">Pilih Supplier</label>
                                <select id="selectSupplier" class="mt-1 block w-full">
                                    <option value="">Pilih Semua Supplier</option>
                                    <?php foreach ($supplier_list as $supplier): ?>
                                    <option value="<?php echo htmlspecialchars($supplier['id_supplier']); ?>"><?php echo htmlspecialchars($supplier['nama_supplier']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="chart-container">
                            <canvas id="chartPembelianSupplier"></canvas>
                        </div>
                    </div>
                    <!-- Grafik Penjualan dan Laba Kotor per Produk -->
                    <div class="card col-span-1 md:col-span-2 lg:col-span-3">
                        <h3 class="text-lg font-semibold mb-4 text-gray-800">Grafik Penjualan dan Laba Kotor per Produk</h3>
                        <div class="form-container mb-4 flex flex-col md:flex-row gap-4 items-end">
                            <div class="w-full md:w-1/3">
                                <label for="selectProduk" class="block text-sm font-medium text-gray-700">Pilih Produk</label>
                                <select id="selectProduk" class="mt-1 block w-full">
                                    <option value="">Pilih Produk</option>
                                    <?php foreach ($produk_list as $produk): ?>
                                    <option value="<?php echo htmlspecialchars($produk['id_produk']); ?>"><?php echo htmlspecialchars($produk['nama_produk']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="chart-container mt-4">
                            <canvas id="chartPenjualanLabaProduk"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const dataPenjualanPeriode = <?php echo json_encode($penjualan_periode); ?>;
            const dataLabaKotorPeriode = <?php echo json_encode($laba_kotor_periode); ?>;
            const dataTopProdukQty = <?php echo json_encode($top_produk_qty); ?>;
            const dataTopProdukLaba = <?php echo json_encode($top_produk_laba); ?>;
            const dataTopProdukValue = <?php echo json_encode($top_produk_value); ?>;

            const chartOptions = {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            };

            const ctx1 = document.getElementById('chartProdukQty').getContext('2d');
            new Chart(ctx1, {
                type: 'bar',
                data: {
                    labels: dataTopProdukQty.map(item => item.nama_produk),
                    datasets: [{
                        label: 'Total Kuantitas Terjual',
                        data: dataTopProdukQty.map(item => item.total_qty),
                        backgroundColor: '#4a90e2'
                    }]
                },
                options: chartOptions
            });

            const ctx2 = document.getElementById('chartProdukLaba').getContext('2d');
            new Chart(ctx2, {
                type: 'bar',
                data: {
                    labels: dataTopProdukLaba.map(item => item.nama_produk),
                    datasets: [{
                        label: 'Total Laba Kotor',
                        data: dataTopProdukLaba.map(item => item.total_laba),
                        backgroundColor: '#38a169'
                    }]
                },
                options: chartOptions
            });

            const ctx3 = document.getElementById('chartProdukValue').getContext('2d');
            new Chart(ctx3, {
                type: 'bar',
                data: {
                    labels: dataTopProdukValue.map(item => item.nama_produk),
                    datasets: [{
                        label: 'Total Nominal Penjualan',
                        data: dataTopProdukValue.map(item => item.total_nominal),
                        backgroundColor: '#d69e2e'
                    }]
                },
                options: chartOptions
            });

            const ctx4 = document.getElementById('chartPenjualanPeriode').getContext('2d');
            new Chart(ctx4, {
                type: 'line',
                data: {
                    labels: dataPenjualanPeriode.map(item => item.periode),
                    datasets: [{
                        label: 'Total Penjualan',
                        data: dataPenjualanPeriode.map(item => item.total_penjualan),
                        borderColor: '#4a90e2',
                        backgroundColor: 'rgba(74, 144, 226, 0.2)',
                        fill: true
                    }]
                },
                options: chartOptions
            });

            const ctx5 = document.getElementById('chartLabaKotorPeriode').getContext('2d');
            new Chart(ctx5, {
                type: 'line',
                data: {
                    labels: dataLabaKotorPeriode.map(item => item.periode),
                    datasets: [{
                        label: 'Total Laba Kotor',
                        data: dataLabaKotorPeriode.map(item => item.total_laba_kotor),
                        borderColor: '#38a169',
                        backgroundColor: 'rgba(56, 161, 105, 0.2)',
                        fill: true
                    }]
                },
                options: chartOptions
            });

            // Grafik Interaktif
            function updateChart(chart, url, label, backgroundColor) {
                fetch(url)
                    .then(response => response.json())
                    .then(data => {
                        chart.data.labels = data.map(item => item.label);
                        chart.data.datasets[0].data = data.map(item => item.value);
                        chart.data.datasets[0].label = label;
                        chart.data.datasets[0].backgroundColor = backgroundColor;
                        chart.update();
                    });
            }

            const ctx6 = document.getElementById('chartPenjualanPelanggan').getContext('2d');
            const chartPenjualanPelanggan = new Chart(ctx6, {
                type: 'bar',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Grafik Penjualan',
                        data: [],
                        backgroundColor: '#4a90e2'
                    }]
                },
                options: chartOptions
            });

            const selectPelanggan = document.getElementById('selectPelanggan');
            selectPelanggan.addEventListener('change', function() {
                const id_pelanggan = this.value;
                const url = id_pelanggan ? `api_dss.php?type=penjualan_pelanggan&id=${id_pelanggan}` : `api_dss.php?type=penjualan_pelanggan`;
                updateChart(chartPenjualanPelanggan, url, 'Total Penjualan (Rp)', '#4a90e2');
            });
            selectPelanggan.dispatchEvent(new Event('change'));

            const ctx7 = document.getElementById('chartPembelianSupplier').getContext('2d');
            const chartPembelianSupplier = new Chart(ctx7, {
                type: 'bar',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Grafik Pembelian',
                        data: [],
                        backgroundColor: '#d69e2e'
                    }]
                },
                options: chartOptions
            });

            const selectSupplier = document.getElementById('selectSupplier');
            selectSupplier.addEventListener('change', function() {
                const id_supplier = this.value;
                const url = id_supplier ? `api_dss.php?type=pembelian_supplier&id=${id_supplier}` : `api_dss.php?type=pembelian_supplier`;
                updateChart(chartPembelianSupplier, url, 'Total Pembelian (Rp)', '#d69e2e');
            });
            selectSupplier.dispatchEvent(new Event('change'));

            const ctx8 = document.getElementById('chartPenjualanLabaProduk').getContext('2d');
            const chartPenjualanLabaProduk = new Chart(ctx8, {
                type: 'bar',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Penjualan (Rp)',
                        data: [],
                        backgroundColor: '#4a90e2',
                        yAxisID: 'y',
                    }, {
                        label: 'Laba Kotor (Rp)',
                        data: [],
                        backgroundColor: '#38a169',
                        yAxisID: 'y',
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            type: 'linear',
                            display: true,
                            position: 'left',
                        }
                    }
                }
            });
            const selectProduk = document.getElementById('selectProduk');
            selectProduk.addEventListener('change', function() {
                const id_produk = this.value;
                const url = `api_dss.php?type=penjualan_laba_produk&id=${id_produk}`;
                fetch(url)
                    .then(response => response.json())
                    .then(data => {
                        chartPenjualanLabaProduk.data.labels = data.labels;
                        chartPenjualanLabaProduk.data.datasets[0].data = data.penjualan;
                        chartPenjualanLabaProduk.data.datasets[1].data = data.laba_kotor;
                        chartPenjualanLabaProduk.update();
                    });
            });

        });
    </script>
</body>
</html>
