<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];

// Mengambil data produk untuk filter
$products = $koneksi->query("SELECT nama_produk, kode_produk, type_produk, merk_produk, kategori_produk FROM master_produk ORDER BY nama_produk")->fetch_all(MYSQLI_ASSOC);

$sql = "SELECT sh.*, mp.kode_produk, mp.nama_produk, mp.type_produk, mp.merk_produk, mp.kategori_produk FROM stok_history sh JOIN master_produk mp ON sh.id_produk = mp.id_produk WHERE 1=1";
$params = [];
$types = '';

// Handling filters
if (isset($_GET['filter_dokumen']) && !empty($_GET['filter_dokumen'])) {
    $sql .= " AND sh.id_dokumen LIKE ?";
    $params[] = '%' . $_GET['filter_dokumen'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_kode']) && !empty($_GET['filter_kode'])) {
    $sql .= " AND mp.kode_produk LIKE ?";
    $params[] = '%' . $_GET['filter_kode'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_nama']) && !empty($_GET['filter_nama'])) {
    $sql .= " AND mp.nama_produk LIKE ?";
    $params[] = '%' . $_GET['filter_nama'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_type']) && !empty($_GET['filter_type'])) {
    $sql .= " AND mp.type_produk LIKE ?";
    $params[] = '%' . $_GET['filter_type'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_merk']) && !empty($_GET['filter_merk'])) {
    $sql .= " AND mp.merk_produk LIKE ?";
    $params[] = '%' . $_GET['filter_merk'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_kategori']) && !empty($_GET['filter_kategori'])) {
    $sql .= " AND mp.kategori_produk LIKE ?";
    $params[] = '%' . $_GET['filter_kategori'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_jumlah']) && !empty($_GET['filter_jumlah'])) {
    $sql .= " AND sh.jumlah = ?";
    $params[] = $_GET['filter_jumlah'];
    $types .= 'i';
}
$sql .= " ORDER BY sh.tanggal DESC, sh.id_stok_history DESC";

$stmt = $koneksi->prepare($sql);
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result_history = $stmt->get_result();

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Histori Stok - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .filter-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item active">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Histori Pergerakan Stok</h1>
            </header>
            
            <div class="content-area">
                <div class="filter-container mb-6">
                    <h3 class="text-xl font-semibold mb-4">Filter Histori</h3>
                    <form action="history_stok.php" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div class="input-group">
                                <label for="filter_dokumen" class="block text-gray-700">Nomor Dokumen</label>
                                <input type="text" id="filter_dokumen" name="filter_dokumen" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_dokumen'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_kode" class="block text-gray-700">Kode Produk</label>
                                <select id="filter_kode" name="filter_kode" class="mt-1 block w-full">
                                    <option value="">-- Semua Kode --</option>
                                    <?php foreach ($products as $product): ?>
                                        <option value="<?php echo htmlspecialchars($product['kode_produk']); ?>" <?php echo (isset($_GET['filter_kode']) && $_GET['filter_kode'] == $product['kode_produk']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($product['kode_produk']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_nama" class="block text-gray-700">Nama Produk</label>
                                <select id="filter_nama" name="filter_nama" class="mt-1 block w-full">
                                    <option value="">-- Semua Nama --</option>
                                    <?php foreach ($products as $product): ?>
                                        <option value="<?php echo htmlspecialchars($product['nama_produk']); ?>" <?php echo (isset($_GET['filter_nama']) && $_GET['filter_nama'] == $product['nama_produk']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($product['nama_produk']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_type" class="block text-gray-700">Type Produk</label>
                                <select id="filter_type" name="filter_type" class="mt-1 block w-full">
                                    <option value="">-- Semua Type --</option>
                                    <?php foreach (array_unique(array_column($products, 'type_produk')) as $type): ?>
                                        <option value="<?php echo htmlspecialchars($type); ?>" <?php echo (isset($_GET['filter_type']) && $_GET['filter_type'] == $type) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($type); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_merk" class="block text-gray-700">Merk Produk</label>
                                <select id="filter_merk" name="filter_merk" class="mt-1 block w-full">
                                    <option value="">-- Semua Merk --</option>
                                    <?php foreach (array_unique(array_column($products, 'merk_produk')) as $merk): ?>
                                        <option value="<?php echo htmlspecialchars($merk); ?>" <?php echo (isset($_GET['filter_merk']) && $_GET['filter_merk'] == $merk) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($merk); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_kategori" class="block text-gray-700">Kategori Produk</label>
                                <select id="filter_kategori" name="filter_kategori" class="mt-1 block w-full">
                                    <option value="">-- Semua Kategori --</option>
                                    <?php foreach (array_unique(array_column($products, 'kategori_produk')) as $kategori): ?>
                                        <option value="<?php echo htmlspecialchars($kategori); ?>" <?php echo (isset($_GET['filter_kategori']) && $_GET['filter_kategori'] == $kategori) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($kategori); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                             <div class="input-group">
                                <label for="filter_jumlah" class="block text-gray-700">Jumlah Produk</label>
                                <input type="number" id="filter_jumlah" name="filter_jumlah" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_jumlah'] ?? ''); ?>">
                            </div>
                            <div class="flex items-end space-x-2 mt-4">
                                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition">Filter</button>
                                <a href="history_stok.php" class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 transition">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="table-container">
                    <h3 class="text-xl font-semibold mb-4">Daftar Histori Stok</h3>
                    <div class="table-responsive rounded-lg shadow-sm">
                        <table class="table-auto min-w-full bg-white rounded-lg">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3">Tanggal</th>
                                    <th class="px-6 py-3">No. Dokumen</th>
                                    <th class="px-6 py-3">Kode Produk</th>
                                    <th class="px-6 py-3">Nama Produk</th>
                                    <th class="px-6 py-3">Jumlah</th>
                                    <th class="px-6 py-3">Pergerakan</th>
                                    <th class="px-6 py-3">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result_history->num_rows > 0): ?>
                                    <?php while($row = $result_history->fetch_assoc()): ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['tanggal']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['id_dokumen']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['kode_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900"><?php echo htmlspecialchars($row['jumlah']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo ($row['type_pergerakan'] == 'Masuk') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                                <?php echo htmlspecialchars($row['type_pergerakan']); ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo htmlspecialchars($row['keterangan']); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center text-gray-500">Tidak ada data histori stok yang ditemukan.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
