<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

// Ambil data supplier dari database
$suppliers = [];
$sql_suppliers = "SELECT kode_supplier, nama_supplier FROM master_supplier ORDER BY nama_supplier";
$result_suppliers = $koneksi->query($sql_suppliers);
while ($row = $result_suppliers->fetch_assoc()) {
    $suppliers[] = $row;
}

// Ambil data produk dari database
$products = [];
$sql_products = "SELECT kode_produk, nama_produk, type_produk, merk_produk, kategori_produk FROM master_produk ORDER BY nama_produk";
$result_products = $koneksi->query($sql_products);
while ($row = $result_products->fetch_assoc()) {
    $products[] = $row;
}

$user_role = $_SESSION['role'];
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Pembelian - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar {
            background-color: #ffffff;
            box-shadow: 2px 0 10px rgba(0,0,0,0.05);
        }
        .sidebar-item {
            display: flex;
            align-items: center;
            padding: 1rem 1.5rem;
            color: #666;
            transition: all 0.2s ease;
            border-radius: 10px;
            margin: 0.5rem 1rem;
        }
        .sidebar-item:hover, .sidebar-item.active {
            background-color: #e2e8f0;
            color: #2c5282;
            transform: translateX(5px);
        }
        .sidebar-item i {
            font-size: 1.25rem;
            width: 25px;
            text-align: center;
        }
        .sidebar-item span {
            margin-left: 1rem;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .logo {
            padding: 1rem;
            text-align: center;
            font-size: 1.5rem;
            font-weight: 700;
            color: #333;
        }
        .content-area {
            background-color: #f9fafb;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        .form-container {
            background-color: #ffffff;
            padding: 2.5rem;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
        }
        .input-group label {
            font-weight: 600;
        }
        .input-group input, .input-group select, .input-group textarea {
            border-radius: 10px;
            border-color: #e2e8f0;
            padding: 0.75rem 1rem;
            width: 100%;
            transition: all 0.2s ease;
        }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus {
            outline: none;
            border-color: #5d9cec;
            box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2);
        }
        .btn-primary {
            background-color: #4c51bf;
            color: #ffffff;
            padding: 1rem 2rem;
            border-radius: 10px;
            transition: background-color 0.2s ease;
        }
        .btn-primary:hover {
            background-color: #343a9b;
        }
        .table-responsive {
            overflow-x: auto;
        }
        .table-bordered th, .table-bordered td {
            border: 1px solid #e2e8f0;
            padding: 0.75rem;
        }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item active">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Input Pembelian</h1>
            </header>
            
            <div class="content-area">
                <div class="form-container">
                    <form action="proses_pembelian.php" method="POST">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div class="input-group">
                                <label for="tgl_transaksi" class="block text-gray-700">Tanggal Transaksi</label>
                                <input type="date" id="tgl_transaksi" name="tgl_transaksi" class="mt-1 block w-full" required>
                            </div>
                            <div class="input-group">
                                <label for="no_faktur_beli" class="block text-gray-700">No. Faktur Beli</label>
                                <input type="text" id="no_faktur_beli" name="no_faktur_beli" class="mt-1 block w-full" required>
                            </div>
                            <div class="input-group">
                                <label for="kode_supplier" class="block text-gray-700">Kode Supplier</label>
                                <select id="kode_supplier" name="kode_supplier" class="mt-1 block w-full" required>
                                    <option value="">-- Pilih Supplier --</option>
                                    <?php foreach ($suppliers as $supplier): ?>
                                        <option value="<?php echo htmlspecialchars($supplier['kode_supplier']); ?>" data-nama="<?php echo htmlspecialchars($supplier['nama_supplier']); ?>">
                                            <?php echo htmlspecialchars($supplier['kode_supplier']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="nama_supplier" class="block text-gray-700">Nama Supplier</label>
                                <input type="text" id="nama_supplier" name="nama_supplier" class="mt-1 block w-full bg-gray-100" readonly>
                            </div>
                        </div>

                        <hr class="my-8 border-gray-200">
                        <h3 class="text-xl font-semibold mb-4 text-gray-800">Detail Produk</h3>
                        <div id="product-list" class="space-y-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4 product-item">
                                <div class="input-group">
                                    <label class="block text-gray-700">Kode Produk</label>
                                    <select name="kode_produk[]" class="mt-1 block w-full product-select" required>
                                        <option value="">-- Pilih Produk --</option>
                                        <?php foreach ($products as $product): ?>
                                            <option value="<?php echo htmlspecialchars($product['kode_produk']); ?>"
                                                data-nama="<?php echo htmlspecialchars($product['nama_produk']); ?>"
                                                data-type="<?php echo htmlspecialchars($product['type_produk']); ?>"
                                                data-merk="<?php echo htmlspecialchars($product['merk_produk']); ?>"
                                                data-kategori="<?php echo htmlspecialchars($product['kategori_produk']); ?>">
                                                <?php echo htmlspecialchars($product['kode_produk']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Nama Produk</label>
                                    <input type="text" name="nama_produk[]" class="mt-1 block w-full bg-gray-100" readonly>
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Type Produk</label>
                                    <input type="text" name="type_produk[]" class="mt-1 block w-full bg-gray-100" readonly>
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Merk Produk</label>
                                    <input type="text" name="merk_produk[]" class="mt-1 block w-full bg-gray-100" readonly>
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Kategori Produk</label>
                                    <input type="text" name="kategori_produk[]" class="mt-1 block w-full bg-gray-100" readonly>
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Jumlah</label>
                                    <input type="number" name="jumlah_produk[]" class="mt-1 block w-full jumlah-produk" required min="1">
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Satuan</label>
                                    <select name="satuan[]" class="mt-1 block w-full" required>
                                        <option value="unit">unit</option>
                                        <option value="meter">meter</option>
                                        <option value="batang">batang</option>
                                        <option value="kotak">kotak</option>
                                        <option value="paket">paket</option>
                                    </select>
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Harga Satuan</label>
                                    <input type="number" step="0.01" name="harga_satuan_produk[]" class="mt-1 block w-full harga-satuan" required min="0">
                                </div>
                                <div class="input-group">
                                    <label class="block text-gray-700">Harga Total</label>
                                    <input type="text" name="harga_total_produk[]" class="mt-1 block w-full harga-total bg-gray-100" readonly>
                                </div>
                                <div class="flex items-end">
                                    <button type="button" class="btn-remove-item bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600">Hapus</button>
                                </div>
                            </div>
                        </div>

                        <div class="mt-6 flex justify-between items-center">
                            <button type="button" id="add-product-btn" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600"><i class="fas fa-plus-circle mr-2"></i>Tambah Produk</button>
                            <span class="text-xl font-bold text-gray-800">Total Pembelian: <span id="grand-total">0.00</span></span>
                        </div>
                        
                        <hr class="my-8 border-gray-200">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div class="input-group">
                                <label for="status_pembayaran" class="block text-gray-700">Status Pembayaran</label>
                                <select id="status_pembayaran" name="status_pembayaran" class="mt-1 block w-full" required>
                                    <option value="Lunas">Lunas</option>
                                    <option value="Belum Lunas">Belum Lunas</option>
                                </select>
                            </div>
                            <div class="input-group lg:col-span-2">
                                <label for="keterangan" class="block text-gray-700">Keterangan</label>
                                <textarea id="keterangan" name="keterangan" rows="2" class="mt-1 block w-full"></textarea>
                            </div>
                        </div>

                        <div class="mt-8 text-right">
                            <button type="submit" class="btn-primary">Simpan Transaksi</button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        const productsData = <?php echo json_encode($products); ?>;
        const suppliersData = <?php echo json_encode($suppliers); ?>;

        document.addEventListener('DOMContentLoaded', function() {
            // Autofill Nama Supplier
            const supplierSelect = document.getElementById('kode_supplier');
            const namaSupplierInput = document.getElementById('nama_supplier');
            supplierSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                namaSupplierInput.value = selectedOption.getAttribute('data-nama');
            });

            // Handle Product List
            const productList = document.getElementById('product-list');
            const addProductBtn = document.getElementById('add-product-btn');
            
            addProductBtn.addEventListener('click', function() {
                const template = productList.querySelector('.product-item').cloneNode(true);
                template.querySelector('input[type="text"]').value = '';
                template.querySelector('input[type="number"]').value = '';
                template.querySelector('select').selectedIndex = 0;
                template.querySelector('.harga-total').value = '';
                
                // Clear the product selection and autofill fields
                const newProductSelect = template.querySelector('.product-select');
                newProductSelect.value = '';
                newProductSelect.closest('.product-item').querySelectorAll('input[type="text"]').forEach(input => input.value = '');

                productList.appendChild(template);
            });

            productList.addEventListener('click', function(e) {
                if (e.target.classList.contains('btn-remove-item')) {
                    if (productList.children.length > 1) {
                        e.target.closest('.product-item').remove();
                        calculateGrandTotal();
                    } else {
                        alert('Minimal harus ada satu produk.');
                    }
                }
            });

            productList.addEventListener('change', function(e) {
                if (e.target.classList.contains('product-select')) {
                    const selectedOption = e.target.options[e.target.selectedIndex];
                    const itemContainer = e.target.closest('.product-item');
                    itemContainer.querySelector('[name="nama_produk[]"]').value = selectedOption.getAttribute('data-nama');
                    itemContainer.querySelector('[name="type_produk[]"]').value = selectedOption.getAttribute('data-type');
                    itemContainer.querySelector('[name="merk_produk[]"]').value = selectedOption.getAttribute('data-merk');
                    itemContainer.querySelector('[name="kategori_produk[]"]').value = selectedOption.getAttribute('data-kategori');
                }
            });

            productList.addEventListener('input', function(e) {
                if (e.target.classList.contains('jumlah-produk') || e.target.classList.contains('harga-satuan')) {
                    const itemContainer = e.target.closest('.product-item');
                    const jumlah = parseFloat(itemContainer.querySelector('.jumlah-produk').value) || 0;
                    const harga = parseFloat(itemContainer.querySelector('.harga-satuan').value) || 0;
                    const total = jumlah * harga;
                    itemContainer.querySelector('.harga-total').value = total.toFixed(2);
                    calculateGrandTotal();
                }
            });

            function calculateGrandTotal() {
                let grandTotal = 0;
                productList.querySelectorAll('.harga-total').forEach(input => {
                    grandTotal += parseFloat(input.value) || 0;
                });
                document.getElementById('grand-total').innerText = grandTotal.toFixed(2);
            }
        });
    </script>
</body>
</html>
