<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$sql_pelanggan = "SELECT id_pelanggan, kode_langganan, nama_langganan FROM master_pelanggan ORDER BY nama_langganan ASC";
$result_pelanggan = $koneksi->query($sql_pelanggan);

$sql_produk = "SELECT id_produk, kode_produk, nama_produk, type_produk, merk_produk, kategori_produk, stok FROM master_produk ORDER BY nama_produk ASC";
$result_produk = $koneksi->query($sql_produk);

$koneksi->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Penjualan - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .form-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .btn { padding: 0.75rem 1.5rem; border-radius: 10px; transition: all 0.2s ease; font-weight: 600; }
        .btn-green { background-color: #38a169; color: white; }
        .btn-green:hover { background-color: #2f855a; }
        .btn-blue { background-color: #4a90e2; color: white; }
        .btn-blue:hover { background-color: #357bd8; }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
        .alert-success { background-color: #d1fae5; color: #065f46; padding: 1rem; border-radius: 10px; margin-bottom: 1.5rem; }
        .alert-error { background-color: #fee2e2; color: #991b1b; padding: 1rem; border-radius: 10px; margin-bottom: 1.5rem; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=master_produk" class="sidebar-item">
                        <i class="fas fa-cube"></i>
                        <span>Master Produk</span>
                    </a>
                    <a href="dashboard.php?page=master_supplier" class="sidebar-item">
                        <i class="fas fa-truck-loading"></i>
                        <span>Master Supplier</span>
                    </a>
                    <a href="dashboard.php?page=master_pelanggan" class="sidebar-item">
                        <i class="fas fa-users"></i>
                        <span>Master Pelanggan</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item active">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($_SESSION['role'] == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Input Penjualan</h1>
                <nav class="text-sm text-gray-500">
                    <a href="dashboard.php?page=penjualan" class="hover:text-gray-700">Penjualan</a> / Input Penjualan
                </nav>
            </header>
            
            <div class="content-area">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
                    <a href="dashboard.php?page=input_penjualan" class="bg-white p-6 rounded-xl shadow-md flex flex-col items-center justify-center text-center hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-plus-circle text-4xl mb-3 text-blue-500"></i>
                        <span class="text-gray-700 font-semibold">Input Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=view_penjualan" class="bg-white p-6 rounded-xl shadow-md flex flex-col items-center justify-center text-center hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-eye text-4xl mb-3 text-green-500"></i>
                        <span class="text-gray-700 font-semibold">View Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=laporan_penjualan" class="bg-white p-6 rounded-xl shadow-md flex flex-col items-center justify-center text-center hover:shadow-lg transition-shadow duration-300">
                        <i class="fas fa-file-invoice-dollar text-4xl mb-3 text-purple-500"></i>
                        <span class="text-gray-700 font-semibold">Laporan Penjualan</span>
                    </a>
                </div>

                <div class="form-container">
                    <h2 class="text-2xl font-bold mb-6 text-center text-gray-800">Formulir Input Penjualan</h2>
                    <form action="proses_penjualan.php" method="POST">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="input-group">
                                <label for="tgl_transaksi" class="block text-gray-700">Tanggal Transaksi</label>
                                <input type="date" id="tgl_transaksi" name="tgl_transaksi" class="mt-1 block" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                            <div class="input-group">
                                <label for="kode_langganan" class="block text-gray-700">Kode Langganan</label>
                                <select id="kode_langganan" name="kode_langganan" class="mt-1 block" required>
                                    <option value="">Pilih Pelanggan</option>
                                    <?php while($row = $result_pelanggan->fetch_assoc()): ?>
                                    <option value="<?php echo htmlspecialchars($row['kode_langganan']); ?>" data-nama="<?php echo htmlspecialchars($row['nama_langganan']); ?>"><?php echo htmlspecialchars($row['kode_langganan']); ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="nama_langganan" class="block text-gray-700">Nama Langganan</label>
                                <input type="text" id="nama_langganan" name="nama_langganan" class="mt-1 block" readonly>
                            </div>
                            <div class="input-group">
                                <label for="status_pembayaran" class="block text-gray-700">Status Pembayaran</label>
                                <select id="status_pembayaran" name="status_pembayaran" class="mt-1 block" required>
                                    <option value="Lunas">Lunas</option>
                                    <option value="Belum Lunas">Belum Lunas</option>
                                </select>
                            </div>
                            <div class="input-group md:col-span-2">
                                <label for="keterangan" class="block text-gray-700">Keterangan</label>
                                <textarea id="keterangan" name="keterangan" rows="2" class="mt-1 block"></textarea>
                            </div>
                        </div>

                        <hr class="my-8">

                        <h3 class="text-xl font-bold mb-4">Detail Produk</h3>
                        <div id="product-list">
                            <div class="product-item p-4 mb-4 border rounded-lg bg-gray-50 grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-4">
                                <div class="input-group col-span-1 md:col-span-2">
                                    <label for="kode_produk_1" class="block text-gray-700">Kode Produk</label>
                                    <select id="kode_produk_1" name="kode_produk[]" class="mt-1 block product-select" required>
                                        <option value="">Pilih Produk</option>
                                        <?php $result_produk->data_seek(0); while($row = $result_produk->fetch_assoc()): ?>
                                        <option value="<?php echo htmlspecialchars($row['kode_produk']); ?>"
                                                data-nama="<?php echo htmlspecialchars($row['nama_produk']); ?>"
                                                data-type="<?php echo htmlspecialchars($row['type_produk']); ?>"
                                                data-merk="<?php echo htmlspecialchars($row['merk_produk']); ?>"
                                                data-kategori="<?php echo htmlspecialchars($row['kategori_produk']); ?>"
                                                data-stok="<?php echo htmlspecialchars($row['stok']); ?>">
                                            <?php echo htmlspecialchars($row['kode_produk']); ?>
                                        </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                                <div class="input-group">
                                    <label for="nama_produk_1" class="block text-gray-700">Nama Produk</label>
                                    <input type="text" id="nama_produk_1" class="mt-1 block product-name" readonly>
                                </div>
                                <div class="input-group">
                                    <label for="type_produk_1" class="block text-gray-700">Tipe Produk</label>
                                    <input type="text" id="type_produk_1" class="mt-1 block product-type" readonly>
                                </div>
                                <div class="input-group">
                                    <label for="merk_produk_1" class="block text-gray-700">Merk</label>
                                    <input type="text" id="merk_produk_1" class="mt-1 block product-merk" readonly>
                                </div>
                                <div class="input-group">
                                    <label for="kategori_produk_1" class="block text-gray-700">Kategori</label>
                                    <input type="text" id="kategori_produk_1" class="mt-1 block product-kategori" readonly>
                                </div>
                                <div class="input-group">
                                    <label for="jumlah_produk_1" class="block text-gray-700">Jumlah Produk</label>
                                    <input type="number" id="jumlah_produk_1" name="jumlah_produk[]" class="mt-1 block product-qty" min="1" required>
                                </div>
                                <div class="input-group">
                                    <label for="harga_satuan_produk_1" class="block text-gray-700">Harga Satuan</label>
                                    <input type="number" id="harga_satuan_produk_1" name="harga_satuan_produk[]" class="mt-1 block product-price" required>
                                </div>
                                <div class="input-group">
                                    <label for="harga_total_produk_1" class="block text-gray-700">Harga Total</label>
                                    <input type="number" id="harga_total_produk_1" name="harga_total_produk[]" class="mt-1 block product-total" readonly>
                                </div>
                                <div class="input-group">
                                    <label for="satuan_1" class="block text-gray-700">Satuan</label>
                                    <select id="satuan_1" name="satuan[]" class="mt-1 block" required>
                                        <option value="unit">unit</option>
                                        <option value="meter">meter</option>
                                        <option value="batang">batang</option>
                                        <option value="kotak">kotak</option>
                                        <option value="paket">paket</option>
                                        <option value="kegiatan">kegiatan</option>
                                        <option value="proses">proses</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="flex justify-end mt-4 gap-2">
                            <button type="button" id="addProductBtn" class="btn btn-blue">Tambah Produk</button>
                            <button type="submit" class="btn btn-green">Simpan Penjualan</button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let productCounter = 1;

            const customerSelect = document.getElementById('kode_langganan');
            customerSelect.addEventListener('change', function() {
                const selectedOption = this.options[this.selectedIndex];
                const namaLangganan = selectedOption.dataset.nama || '';
                document.getElementById('nama_langganan').value = namaLangganan;
            });

            const productListContainer = document.getElementById('product-list');

            function handleProductChange(e) {
                const target = e.target;
                if (target.classList.contains('product-select')) {
                    const selectedOption = target.options[target.selectedIndex];
                    const parent = target.closest('.product-item');
                    const namaProduk = selectedOption.dataset.nama || '';
                    const typeProduk = selectedOption.dataset.type || '';
                    const merkProduk = selectedOption.dataset.merk || '';
                    const kategoriProduk = selectedOption.dataset.kategori || '';
                    const stokProduk = selectedOption.dataset.stok || '0';

                    parent.querySelector('.product-name').value = namaProduk;
                    parent.querySelector('.product-type').value = typeProduk;
                    parent.querySelector('.product-merk').value = merkProduk;
                    parent.querySelector('.product-kategori').value = kategoriProduk;
                    parent.querySelector('.product-qty').max = stokProduk;
                    parent.querySelector('.product-qty').value = '';
                    parent.querySelector('.product-price').value = '';
                    parent.querySelector('.product-total').value = '';
                }
            }

            function handlePriceChange(e) {
                const target = e.target;
                if (target.classList.contains('product-qty') || target.classList.contains('product-price')) {
                    const parent = target.closest('.product-item');
                    const qty = parent.querySelector('.product-qty').value;
                    const price = parent.querySelector('.product-price').value;
                    const total = qty * price;
                    parent.querySelector('.product-total').value = isNaN(total) ? 0 : total;
                }
            }

            document.getElementById('addProductBtn').addEventListener('click', function() {
                productCounter++;
                const newProductItem = document.createElement('div');
                newProductItem.classList.add('product-item', 'p-4', 'mb-4', 'border', 'rounded-lg', 'bg-gray-50', 'grid', 'grid-cols-1', 'md:grid-cols-3', 'lg:grid-cols-5', 'gap-4');
                newProductItem.innerHTML = `
                    <div class="input-group col-span-1 md:col-span-2">
                        <label for="kode_produk_${productCounter}" class="block text-gray-700">Kode Produk</label>
                        <select id="kode_produk_${productCounter}" name="kode_produk[]" class="mt-1 block product-select" required>
                            <option value="">Pilih Produk</option>
                            <?php $result_produk->data_seek(0); while($row = $result_produk->fetch_assoc()): ?>
                            <option value="<?php echo htmlspecialchars($row['kode_produk']); ?>"
                                    data-nama="<?php echo htmlspecialchars($row['nama_produk']); ?>"
                                    data-type="<?php echo htmlspecialchars($row['type_produk']); ?>"
                                    data-merk="<?php echo htmlspecialchars($row['merk_produk']); ?>"
                                    data-kategori="<?php echo htmlspecialchars($row['kategori_produk']); ?>"
                                    data-stok="<?php echo htmlspecialchars($row['stok']); ?>">
                                <?php echo htmlspecialchars($row['kode_produk']); ?>
                            </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="input-group">
                        <label for="nama_produk_${productCounter}" class="block text-gray-700">Nama Produk</label>
                        <input type="text" id="nama_produk_${productCounter}" class="mt-1 block product-name" readonly>
                    </div>
                    <div class="input-group">
                        <label for="type_produk_${productCounter}" class="block text-gray-700">Tipe Produk</label>
                        <input type="text" id="type_produk_${productCounter}" class="mt-1 block product-type" readonly>
                    </div>
                    <div class="input-group">
                        <label for="merk_produk_${productCounter}" class="block text-gray-700">Merk</label>
                        <input type="text" id="merk_produk_${productCounter}" class="mt-1 block product-merk" readonly>
                    </div>
                    <div class="input-group">
                        <label for="kategori_produk_${productCounter}" class="block text-gray-700">Kategori</label>
                        <input type="text" id="kategori_produk_${productCounter}" class="mt-1 block product-kategori" readonly>
                    </div>
                    <div class="input-group">
                        <label for="jumlah_produk_${productCounter}" class="block text-gray-700">Jumlah Produk</label>
                        <input type="number" id="jumlah_produk_${productCounter}" name="jumlah_produk[]" class="mt-1 block product-qty" min="1" required>
                    </div>
                    <div class="input-group">
                        <label for="harga_satuan_produk_${productCounter}" class="block text-gray-700">Harga Satuan</label>
                        <input type="number" id="harga_satuan_produk_${productCounter}" name="harga_satuan_produk[]" class="mt-1 block product-price" required>
                    </div>
                    <div class="input-group">
                        <label for="harga_total_produk_${productCounter}" class="block text-gray-700">Harga Total</label>
                        <input type="number" id="harga_total_produk_${productCounter}" name="harga_total_produk[]" class="mt-1 block product-total" readonly>
                    </div>
                    <div class="input-group">
                        <label for="satuan_${productCounter}" class="block text-gray-700">Satuan</label>
                        <select id="satuan_${productCounter}" name="satuan[]" class="mt-1 block" required>
                            <option value="unit">unit</option>
                            <option value="meter">meter</option>
                            <option value="batang">batang</option>
                            <option value="kotak">kotak</option>
                            <option value="paket">paket</option>
                            <option value="kegiatan">kegiatan</option>
                            <option value="proses">proses</option>
                        </select>
                    </div>
                    <div class="input-group self-end">
                        <button type="button" class="btn bg-red-500 hover:bg-red-700 text-white delete-product">Hapus</button>
                    </div>
                `;
                productListContainer.appendChild(newProductItem);
            });

            productListContainer.addEventListener('change', handleProductChange);
            productListContainer.addEventListener('input', handlePriceChange);
            productListContainer.addEventListener('click', function(e) {
                if (e.target.classList.contains('delete-product')) {
                    e.target.closest('.product-item').remove();
                }
            });
        });
    </script>
</body>
</html>
