<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$sql_penjualan = "SELECT no_faktur_jual FROM transaksi_penjualan ORDER BY tgl_transaksi DESC";
$result_penjualan = $koneksi->query($sql_penjualan);

$sql_produk = "SELECT id_produk, kode_produk, nama_produk, type_produk, merk_produk, kategori_produk FROM master_produk ORDER BY nama_produk ASC";
$result_produk = $koneksi->query($sql_produk);

$koneksi->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Input Retur Penjualan - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .form-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .btn { padding: 0.75rem 1.5rem; border-radius: 10px; transition: all 0.2s ease; font-weight: 600; }
        .btn-green { background-color: #38a169; color: white; }
        .btn-green:hover { background-color: #2f855a; }
        .btn-blue { background-color: #4a90e2; color: white; }
        .btn-blue:hover { background-color: #357bd8; }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
        .alert-success { background-color: #d1fae5; color: #065f46; padding: 1rem; border-radius: 10px; margin-bottom: 1.5rem; }
        .alert-error { background-color: #fee2e2; color: #991b1b; padding: 1rem; border-radius: 10px; margin-bottom: 1.5rem; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=master_produk" class="sidebar-item">
                        <i class="fas fa-cube"></i>
                        <span>Master Produk</span>
                    </a>
                    <a href="dashboard.php?page=master_supplier" class="sidebar-item">
                        <i class="fas fa-truck-loading"></i>
                        <span>Master Supplier</span>
                    </a>
                    <a href="dashboard.php?page=master_pelanggan" class="sidebar-item">
                        <i class="fas fa-users"></i>
                        <span>Master Pelanggan</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item active">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($_SESSION['role'] == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Input Retur Penjualan</h1>
                <nav class="text-sm text-gray-500">
                    <a href="dashboard.php?page=retur_penjualan" class="hover:text-gray-700">Retur Penjualan</a> / Input Retur Penjualan
                </nav>
            </header>
            
            <div class="content-area">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="form-container">
                        <h2 class="text-2xl font-bold mb-6 text-center text-gray-800">Formulir Retur Penjualan</h2>
                        <form action="proses_retur_penjualan.php" method="POST">
                            <div class="input-group mb-4">
                                <label for="no_retur" class="block text-gray-700">No. Retur</label>
                                <input type="text" id="no_retur" name="no_retur" class="mt-1 block bg-gray-100 cursor-not-allowed" value="<?php echo 'RTP-' . date('Ymd') . '-' . rand(1000, 9999); ?>" readonly>
                            </div>
                            <div class="input-group mb-4">
                                <label for="tgl_retur" class="block text-gray-700">Tanggal Retur</label>
                                <input type="date" id="tgl_retur" name="tgl_retur" class="mt-1 block" value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                            <div class="input-group mb-4">
                                <label for="no_faktur_jual" class="block text-gray-700">No. Faktur Jual</label>
                                <select id="no_faktur_jual" name="no_faktur_jual" class="mt-1 block" required>
                                    <option value="">Pilih Faktur Penjualan</option>
                                    <?php while($row = $result_penjualan->fetch_assoc()): ?>
                                    <option value="<?php echo htmlspecialchars($row['no_faktur_jual']); ?>"><?php echo htmlspecialchars($row['no_faktur_jual']); ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="input-group mb-4">
                                <label for="kode_produk" class="block text-gray-700">Kode Produk</label>
                                <select id="kode_produk" name="kode_produk" class="mt-1 block" required>
                                    <option value="">Pilih Produk</option>
                                    <?php while($row = $result_produk->fetch_assoc()): ?>
                                    <option 
                                        value="<?php echo htmlspecialchars($row['kode_produk']); ?>" 
                                        data-nama="<?php echo htmlspecialchars($row['nama_produk']); ?>"
                                        data-type="<?php echo htmlspecialchars($row['type_produk']); ?>"
                                        data-merk="<?php echo htmlspecialchars($row['merk_produk']); ?>"
                                        data-kategori="<?php echo htmlspecialchars($row['kategori_produk']); ?>"
                                    >
                                        <?php echo htmlspecialchars($row['kode_produk']); ?>
                                    </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="input-group mb-4">
                                    <label for="nama_produk" class="block text-gray-700">Nama Produk</label>
                                    <input type="text" id="nama_produk" name="nama_produk" class="mt-1 block" readonly>
                                </div>
                                <div class="input-group mb-4">
                                    <label for="type_produk" class="block text-gray-700">Tipe Produk</label>
                                    <input type="text" id="type_produk" name="type_produk" class="mt-1 block" readonly>
                                </div>
                                <div class="input-group mb-4">
                                    <label for="merk_produk" class="block text-gray-700">Merk Produk</label>
                                    <input type="text" id="merk_produk" name="merk_produk" class="mt-1 block" readonly>
                                </div>
                                <div class="input-group mb-4">
                                    <label for="kategori_produk" class="block text-gray-700">Kategori Produk</label>
                                    <input type="text" id="kategori_produk" name="kategori_produk" class="mt-1 block" readonly>
                                </div>
                            </div>
                            <div class="input-group mb-4">
                                <label for="jumlah_retur" class="block text-gray-700">Jumlah Retur</label>
                                <input type="number" id="jumlah_retur" name="jumlah_retur" class="mt-1 block" required>
                            </div>
                            <div class="input-group mb-4">
                                <label for="alasan_retur" class="block text-gray-700">Alasan Retur</label>
                                <textarea id="alasan_retur" name="alasan_retur" rows="3" class="mt-1 block" required></textarea>
                            </div>
                            <div class="flex justify-end">
                                <button type="submit" class="btn btn-green">Simpan Retur</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <script>
        document.getElementById('kode_produk').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            document.getElementById('nama_produk').value = selectedOption.dataset.nama || '';
            document.getElementById('type_produk').value = selectedOption.dataset.type || '';
            document.getElementById('merk_produk').value = selectedOption.dataset.merk || '';
            document.getElementById('kategori_produk').value = selectedOption.dataset.kategori || '';
        });
    </script>
</body>
</html>
