<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true || $_SESSION['role'] !== 'admin') {
    header("location: dashboard.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-01');
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');
$total_laba_kotor = 0;

$sql = "SELECT tp.no_faktur_jual, tp.tgl_transaksi, mp.nama_produk, mp.harga_modal, tpd.harga_satuan, tpd.jumlah_produk 
        FROM transaksi_penjualan tp
        JOIN transaksi_penjualan_detail tpd ON tp.id_penjualan = tpd.id_penjualan
        JOIN master_produk mp ON tpd.id_produk = mp.id_produk
        WHERE tp.tgl_transaksi BETWEEN ? AND ?
        ORDER BY tp.tgl_transaksi DESC";
$stmt = $koneksi->prepare($sql);
$stmt->bind_param("ss", $start_date, $end_date);
$stmt->execute();
$result = $stmt->get_result();

$data_laporan = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $laba_kotor_produk = ($row['harga_satuan'] - $row['harga_modal']) * $row['jumlah_produk'];
        $row['laba_kotor'] = $laba_kotor_produk;
        $total_laba_kotor += $laba_kotor_produk;
        $data_laporan[] = $row;
    }
}
$stmt->close();
$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laba Kotor - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .form-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
        .btn { padding: 0.5rem 1rem; border-radius: 8px; transition: all 0.2s ease; font-weight: 600; }
        .btn-green { background-color: #38a169; color: white; }
        .btn-green:hover { background-color: #2f855a; }
        .btn-blue { background-color: #4a90e2; color: white; }
        .btn-blue:hover { background-color: #357bd8; }
        .btn-print { background-color: #718096; color: white; }
        .btn-print:hover { background-color: #4a5568; }
        .summary-box {
            background-color: #fff;
            padding: 1.5rem;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            text-align: center;
        }
        .summary-box h3 { font-size: 1.25rem; font-weight: 600; color: #4a5568; }
        .summary-box p { font-size: 2.5rem; font-weight: 700; color: #38a169; margin-top: 0.5rem; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=master_produk" class="sidebar-item">
                        <i class="fas fa-cube"></i>
                        <span>Master Produk</span>
                    </a>
                    <a href="dashboard.php?page=master_supplier" class="sidebar-item">
                        <i class="fas fa-truck-loading"></i>
                        <span>Master Supplier</span>
                    </a>
                    <a href="dashboard.php?page=master_pelanggan" class="sidebar-item">
                        <i class="fas fa-users"></i>
                        <span>Master Pelanggan</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item active">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Laba Kotor (Gross Profit)</h1>
            </header>
            
            <div class="content-area">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8 items-center">
                    <div class="summary-box col-span-2 md:col-span-1">
                        <h3>Total Laba Kotor</h3>
                        <p>Rp <?php echo number_format($total_laba_kotor, 0, ',', '.'); ?></p>
                    </div>
                    <div class="col-span-1 md:col-span-2">
                        <div class="form-container p-6">
                            <h3 class="text-lg font-semibold mb-3">Filter Laporan Berdasarkan Tanggal</h3>
                            <form action="laba_kotor.php" method="GET" class="flex flex-col md:flex-row gap-4 items-end">
                                <div class="w-full md:w-1/2">
                                    <label for="start_date" class="block text-sm font-medium text-gray-700">Dari Tanggal</label>
                                    <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>" class="mt-1 block w-full">
                                </div>
                                <div class="w-full md:w-1/2">
                                    <label for="end_date" class="block text-sm font-medium text-gray-700">Sampai Tanggal</label>
                                    <input type="date" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>" class="mt-1 block w-full">
                                </div>
                                <div class="w-full md:w-auto">
                                    <button type="submit" class="btn btn-blue w-full">Tampilkan</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
                <div class="table-container">
                    <h3 class="text-xl font-semibold mb-4">Detail Laba Kotor per Transaksi</h3>
                    <div class="table-responsive rounded-lg shadow-sm">
                        <table class="table-auto min-w-full bg-white rounded-lg">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3">No. Faktur Jual</th>
                                    <th class="px-6 py-3">Tanggal</th>
                                    <th class="px-6 py-3">Nama Produk</th>
                                    <th class="px-6 py-3">Harga Jual</th>
                                    <th class="px-6 py-3">Harga Modal</th>
                                    <th class="px-6 py-3">Jumlah Produk</th>
                                    <th class="px-6 py-3">Laba Kotor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($data_laporan)): ?>
                                    <?php foreach ($data_laporan as $row): ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['no_faktur_jual']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['tgl_transaksi']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['harga_satuan'], 0, ',', '.'); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['harga_modal'], 0, ',', '.'); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['jumlah_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-green-600">Rp <?php echo number_format($row['laba_kotor'], 0, ',', '.'); ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center text-gray-500">Tidak ada data laba kotor dalam periode ini.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
