<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];

// Prepare filter values
$filter_faktur = $_GET['filter_faktur'] ?? '';
$filter_tanggal = $_GET['filter_tanggal'] ?? '';
$filter_supplier = $_GET['filter_supplier'] ?? '';
$filter_produk_nama = $_GET['filter_produk_nama'] ?? '';
$filter_produk_type = $_GET['filter_produk_type'] ?? '';
$filter_produk_merk = $_GET['filter_produk_merk'] ?? '';
$filter_produk_kategori = $_GET['filter_produk_kategori'] ?? '';
$filter_jumlah = $_GET['filter_jumlah'] ?? '';
$filter_harga = $_GET['filter_harga'] ?? '';
$filter_status = $_GET['filter_status'] ?? '';
$filter_keterangan = $_GET['filter_keterangan'] ?? '';

// Build the SQL query with comprehensive filters
$sql_query = "SELECT
    tp.no_faktur_beli,
    tp.tgl_transaksi,
    ms.nama_supplier,
    tpd.jumlah_produk,
    tpd.harga_satuan_produk,
    tpd.harga_total_produk,
    tp.status_pembayaran,
    tp.keterangan,
    mp.nama_produk,
    mp.kode_produk,
    mp.type_produk,
    mp.merk_produk,
    mp.kategori_produk
FROM
    transaksi_pembelian tp
JOIN
    master_supplier ms ON tp.id_supplier = ms.id_supplier
JOIN
    transaksi_pembelian_detail tpd ON tp.id_pembelian = tpd.id_pembelian
JOIN
    master_produk mp ON tpd.id_produk = mp.id_produk
WHERE 1=1";

$params = [];
$types = '';

if (!empty($filter_faktur)) {
    $sql_query .= " AND tp.no_faktur_beli LIKE ?";
    $params[] = '%' . $filter_faktur . '%';
    $types .= 's';
}
if (!empty($filter_tanggal)) {
    $sql_query .= " AND tp.tgl_transaksi = ?";
    $params[] = $filter_tanggal;
    $types .= 's';
}
if (!empty($filter_supplier)) {
    $sql_query .= " AND ms.nama_supplier LIKE ?";
    $params[] = '%' . $filter_supplier . '%';
    $types .= 's';
}
if (!empty($filter_produk_nama)) {
    $sql_query .= " AND mp.nama_produk LIKE ?";
    $params[] = '%' . $filter_produk_nama . '%';
    $types .= 's';
}
if (!empty($filter_produk_type)) {
    $sql_query .= " AND mp.type_produk LIKE ?";
    $params[] = '%' . $filter_produk_type . '%';
    $types .= 's';
}
if (!empty($filter_produk_merk)) {
    $sql_query .= " AND mp.merk_produk LIKE ?";
    $params[] = '%' . $filter_produk_merk . '%';
    $types .= 's';
}
if (!empty($filter_produk_kategori)) {
    $sql_query .= " AND mp.kategori_produk LIKE ?";
    $params[] = '%' . $filter_produk_kategori . '%';
    $types .= 's';
}
if (!empty($filter_jumlah)) {
    $sql_query .= " AND tpd.jumlah_produk = ?";
    $params[] = $filter_jumlah;
    $types .= 'i';
}
if (!empty($filter_harga)) {
    $sql_query .= " AND tpd.harga_satuan_produk = ?";
    $params[] = $filter_harga;
    $types .= 'd';
}
if (!empty($filter_status)) {
    $sql_query .= " AND tp.status_pembayaran = ?";
    $params[] = $filter_status;
    $types .= 's';
}
if (!empty($filter_keterangan)) {
    $sql_query .= " AND tp.keterangan LIKE ?";
    $params[] = '%' . $filter_keterangan . '%';
    $types .= 's';
}

$sql_query .= " ORDER BY tp.tgl_transaksi DESC, tp.no_faktur_beli DESC";
$stmt = $koneksi->prepare($sql_query);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Pembelian - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .filter-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
        @media print {
            .no-print { display: none; }
            body { background-color: #fff; }
            .content-area { padding: 1rem; box-shadow: none; border-radius: 0; }
            h1, h2, h3 { color: #000 !important; }
            .table-auto { font-size: 10px; }
            .table-auto th, .table-auto td { padding: 0.5rem; }
        }
    </style>
</head>
<body>
    <div class="flex min-h-screen no-print">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item active">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Laporan Pembelian</h1>
            </header>
            
            <div class="content-area">
                <div class="filter-container mb-6">
                    <h3 class="text-xl font-semibold mb-4">Filter Laporan</h3>
                    <form action="laporan_pembelian.php" method="GET">
                        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div class="input-group">
                                <label for="filter_faktur" class="block text-gray-700">No. Faktur Beli</label>
                                <input type="text" id="filter_faktur" name="filter_faktur" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_faktur); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_tanggal" class="block text-gray-700">Tanggal Transaksi</label>
                                <input type="date" id="filter_tanggal" name="filter_tanggal" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_tanggal); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_supplier" class="block text-gray-700">Nama Supplier</label>
                                <input type="text" id="filter_supplier" name="filter_supplier" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_supplier); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_produk_nama" class="block text-gray-700">Nama Produk</label>
                                <input type="text" id="filter_produk_nama" name="filter_produk_nama" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_produk_nama); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_produk_type" class="block text-gray-700">Type Produk</label>
                                <input type="text" id="filter_produk_type" name="filter_produk_type" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_produk_type); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_produk_merk" class="block text-gray-700">Merk Produk</label>
                                <input type="text" id="filter_produk_merk" name="filter_produk_merk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_produk_merk); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_produk_kategori" class="block text-gray-700">Kategori Produk</label>
                                <input type="text" id="filter_produk_kategori" name="filter_produk_kategori" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_produk_kategori); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_jumlah" class="block text-gray-700">Jumlah Produk</label>
                                <input type="number" id="filter_jumlah" name="filter_jumlah" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_jumlah); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_harga" class="block text-gray-700">Harga Satuan</label>
                                <input type="number" step="0.01" id="filter_harga" name="filter_harga" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_harga); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_status" class="block text-gray-700">Status Pembayaran</label>
                                <select id="filter_status" name="filter_status" class="mt-1 block w-full">
                                    <option value="" <?php echo empty($filter_status) ? 'selected' : ''; ?>>Semua</option>
                                    <option value="Lunas" <?php echo ($filter_status == 'Lunas') ? 'selected' : ''; ?>>Lunas</option>
                                    <option value="Belum Lunas" <?php echo ($filter_status == 'Belum Lunas') ? 'selected' : ''; ?>>Belum Lunas</option>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_keterangan" class="block text-gray-700">Keterangan</label>
                                <input type="text" id="filter_keterangan" name="filter_keterangan" class="mt-1 block w-full" value="<?php echo htmlspecialchars($filter_keterangan); ?>">
                            </div>
                            <div class="flex items-end space-x-2 mt-4 col-span-1 lg:col-span-4">
                                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition">Filter</button>
                                <a href="laporan_pembelian.php" class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 transition">Reset</a>
                                <button type="button" onclick="window.print()" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition">Cetak Laporan</button>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="table-container">
                    <h3 class="text-xl font-semibold mb-4">Hasil Laporan Pembelian</h3>
                    <div class="table-responsive rounded-lg shadow-sm">
                        <table class="table-auto min-w-full bg-white rounded-lg">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3">No. Faktur</th>
                                    <th class="px-6 py-3">Tanggal</th>
                                    <th class="px-6 py-3">Supplier</th>
                                    <th class="px-6 py-3">Produk</th>
                                    <th class="px-6 py-3">Jumlah</th>
                                    <th class="px-6 py-3">Harga Satuan</th>
                                    <th class="px-6 py-3">Harga Total</th>
                                    <th class="px-6 py-3">Status Bayar</th>
                                    <th class="px-6 py-3">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result->num_rows > 0): ?>
                                    <?php while($row = $result->fetch_assoc()): ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['no_faktur_beli']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['tgl_transaksi']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_supplier']); ?></td>
                                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_produk']); ?></td>
                                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo htmlspecialchars($row['jumlah_produk']); ?></td>
                                        <td class="px-6 py-4 text-sm text-gray-500">Rp <?php echo number_format($row['harga_satuan_produk'], 2, ',', '.'); ?></td>
                                        <td class="px-6 py-4 text-sm text-gray-500">Rp <?php echo number_format($row['harga_total_produk'], 2, ',', '.'); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo ($row['status_pembayaran'] == 'Lunas') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                                <?php echo htmlspecialchars($row['status_pembayaran']); ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo htmlspecialchars($row['keterangan']); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="9" class="px-6 py-4 text-center text-gray-500">Tidak ada data pembelian yang cocok dengan filter.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
