<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];

// Handle action for input, edit, delete
$action = isset($_GET['action']) ? $_GET['action'] : 'view';
$product_data = null;
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_product'])) {
        $kode_produk = $_POST['kode_produk'];
        $nama_produk = $_POST['nama_produk'];
        $type_produk = $_POST['type_produk'];
        $merk_produk = $_POST['merk_produk'];
        $kategori_produk = $_POST['kategori_produk'];
        $satuan = $_POST['satuan'];
        $harga_beli = $_POST['harga_beli'];
        $harga_jual = $_POST['harga_jual'];

        $sql = "INSERT INTO master_produk (kode_produk, nama_produk, type_produk, merk_produk, kategori_produk, satuan, harga_beli, harga_jual) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $koneksi->prepare($sql);
        $stmt->bind_param("ssssssdd", $kode_produk, $nama_produk, $type_produk, $merk_produk, $kategori_produk, $satuan, $harga_beli, $harga_jual);
        if ($stmt->execute()) {
            $message = "<div class='bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4' role='alert'>Produk berhasil ditambahkan.</div>";
        } else {
            $message = "<div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4' role='alert'>Error: " . $stmt->error . "</div>";
        }
        $stmt->close();
    } elseif (isset($_POST['edit_product'])) {
        $id = $_POST['id_produk'];
        $kode_produk = $_POST['kode_produk'];
        $nama_produk = $_POST['nama_produk'];
        $type_produk = $_POST['type_produk'];
        $merk_produk = $_POST['merk_produk'];
        $kategori_produk = $_POST['kategori_produk'];
        $satuan = $_POST['satuan'];
        $harga_beli = $_POST['harga_beli'];
        $harga_jual = $_POST['harga_jual'];

        $sql = "UPDATE master_produk SET kode_produk=?, nama_produk=?, type_produk=?, merk_produk=?, kategori_produk=?, satuan=?, harga_beli=?, harga_jual=? WHERE id_produk=?";
        $stmt = $koneksi->prepare($sql);
        $stmt->bind_param("ssssssddi", $kode_produk, $nama_produk, $type_produk, $merk_produk, $kategori_produk, $satuan, $harga_beli, $harga_jual, $id);
        if ($stmt->execute()) {
            $message = "<div class='bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4' role='alert'>Produk berhasil diubah.</div>";
        } else {
            $message = "<div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4' role='alert'>Error: " . $stmt->error . "</div>";
        }
        $stmt->close();
    }
}

if ($action === 'delete' && isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "DELETE FROM master_produk WHERE id_produk = ?";
    $stmt = $koneksi->prepare($sql);
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        $message = "<div class='bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4' role='alert'>Produk berhasil dihapus.</div>";
    } else {
        $message = "<div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4' role='alert'>Error: " . $stmt->error . "</div>";
    }
    $stmt->close();
    $action = 'view';
}

if ($action === 'edit' && isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "SELECT * FROM master_produk WHERE id_produk = ?";
    $stmt = $koneksi->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $product_data = $result->fetch_assoc();
    $stmt->close();
}

// Fetch all products for view
$sql_view = "SELECT * FROM master_produk";
$result_view = $koneksi->query($sql_view);

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Produk - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .form-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
        .btn { padding: 0.5rem 1rem; border-radius: 8px; transition: all 0.2s ease; font-weight: 600; }
        .btn-green { background-color: #38a169; color: white; }
        .btn-green:hover { background-color: #2f855a; }
        .btn-red { background-color: #e53e3e; color: white; }
        .btn-red:hover { background-color: #c53030; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=master_produk" class="sidebar-item active">
                        <i class="fas fa-cube"></i>
                        <span>Master Produk</span>
                    </a>
                    <a href="dashboard.php?page=master_supplier" class="sidebar-item">
                        <i class="fas fa-truck-loading"></i>
                        <span>Master Supplier</span>
                    </a>
                    <a href="dashboard.php?page=master_pelanggan" class="sidebar-item">
                        <i class="fas fa-users"></i>
                        <span>Master Pelanggan</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Master Produk</h1>
                <div>
                    <a href="master_produk.php?action=view" class="btn bg-gray-500 hover:bg-gray-600 text-white">View Produk</a>
                    <a href="master_produk.php?action=add" class="btn bg-blue-500 hover:bg-blue-600 text-white">Input Produk</a>
                </div>
            </header>
            
            <div class="content-area">
                <?php echo $message; ?>
                <?php if ($action === 'add' || $action === 'edit'): ?>
                    <div class="form-container">
                        <h3 class="text-xl font-semibold mb-4"><?php echo ($action === 'add') ? 'Input Produk Baru' : 'Edit Produk'; ?></h3>
                        <form action="master_produk.php" method="POST">
                            <input type="hidden" name="<?php echo ($action === 'add') ? 'add_product' : 'edit_product'; ?>" value="1">
                            <?php if ($action === 'edit'): ?>
                                <input type="hidden" name="id_produk" value="<?php echo htmlspecialchars($product_data['id_produk']); ?>">
                            <?php endif; ?>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="input-group">
                                    <label for="kode_produk" class="block text-gray-700">Kode Produk</label>
                                    <input type="text" id="kode_produk" name="kode_produk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['kode_produk'] ?? ''); ?>" required>
                                </div>
                                <div class="input-group">
                                    <label for="nama_produk" class="block text-gray-700">Nama Produk</label>
                                    <input type="text" id="nama_produk" name="nama_produk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['nama_produk'] ?? ''); ?>" required>
                                </div>
                                <div class="input-group">
                                    <label for="type_produk" class="block text-gray-700">Type Produk</label>
                                    <input type="text" id="type_produk" name="type_produk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['type_produk'] ?? ''); ?>">
                                </div>
                                <div class="input-group">
                                    <label for="merk_produk" class="block text-gray-700">Merk Produk</label>
                                    <input type="text" id="merk_produk" name="merk_produk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['merk_produk'] ?? ''); ?>">
                                </div>
                                <div class="input-group">
                                    <label for="kategori_produk" class="block text-gray-700">Kategori Produk</label>
                                    <input type="text" id="kategori_produk" name="kategori_produk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['kategori_produk'] ?? ''); ?>">
                                </div>
                                <div class="input-group">
                                    <label for="satuan" class="block text-gray-700">Satuan</label>
                                    <select id="satuan" name="satuan" class="mt-1 block w-full" required>
                                        <option value="Unit" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Unit') ? 'selected' : ''; ?>>Unit</option>
                                        <option value="Meter" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Meter') ? 'selected' : ''; ?>>Meter</option>
                                        <option value="Batang" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Batang') ? 'selected' : ''; ?>>Batang</option>
                                        <option value="Kotak" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Kotak') ? 'selected' : ''; ?>>Kotak</option>
                                        <option value="Paket" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Paket') ? 'selected' : ''; ?>>Paket</option>
                                        <option value="Kegiatan" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Kegiatan') ? 'selected' : ''; ?>>Kegiatan</option>
                                        <option value="Proses" <?php echo (isset($product_data['satuan']) && $product_data['satuan'] == 'Proses') ? 'selected' : ''; ?>>Proses</option>
                                    </select>
                                </div>
                                <div class="input-group">
                                    <label for="harga_beli" class="block text-gray-700">Harga Beli</label>
                                    <input type="number" step="0.01" id="harga_beli" name="harga_beli" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['harga_beli'] ?? '0'); ?>" required>
                                </div>
                                <div class="input-group">
                                    <label for="harga_jual" class="block text-gray-700">Harga Jual</label>
                                    <input type="number" step="0.01" id="harga_jual" name="harga_jual" class="mt-1 block w-full" value="<?php echo htmlspecialchars($product_data['harga_jual'] ?? '0'); ?>" required>
                                </div>
                            </div>
                            <div class="mt-6">
                                <button type="submit" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition">Simpan Produk</button>
                                <a href="master_produk.php" class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 transition ml-2">Batal</a>
                            </div>
                        </form>
                    </div>
                <?php else: ?>
                    <div class="table-container">
                        <h3 class="text-xl font-semibold mb-4">Daftar Produk</h3>
                        <div class="table-responsive rounded-lg shadow-sm">
                            <table class="table-auto min-w-full bg-white rounded-lg">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th class="px-6 py-3">Kode</th>
                                        <th class="px-6 py-3">Nama Produk</th>
                                        <th class="px-6 py-3">Type</th>
                                        <th class="px-6 py-3">Kategori</th>
                                        <th class="px-6 py-3">Satuan</th>
                                        <th class="px-6 py-3">Harga Beli</th>
                                        <th class="px-6 py-3">Harga Jual</th>
                                        <th class="px-6 py-3">Stok</th>
                                        <th class="px-6 py-3">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($result_view->num_rows > 0): ?>
                                        <?php while($row = $result_view->fetch_assoc()): ?>
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['kode_produk']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_produk']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['type_produk']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['kategori_produk']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['satuan']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['harga_beli'], 2, ',', '.'); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['harga_jual'], 2, ',', '.'); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900"><?php echo htmlspecialchars($row['stok']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                <a href="master_produk.php?action=edit&id=<?php echo htmlspecialchars($row['id_produk']); ?>" class="text-blue-600 hover:text-blue-900 mr-4">Edit</a>
                                                <a href="master_produk.php?action=delete&id=<?php echo htmlspecialchars($row['id_produk']); ?>" class="text-red-600 hover:text-red-900" onclick="return confirm('Apakah Anda yakin ingin menghapus produk ini?');">Hapus</a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="9" class="px-6 py-4 text-center text-gray-500">Tidak ada data produk yang ditemukan.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</body>
</html>
