<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_payment'])) {
    $id_penjualan = $_POST['id_penjualan'];
    $sql_update = "UPDATE transaksi_penjualan SET status_pembayaran = 'Lunas' WHERE id_penjualan = ?";
    $stmt = $koneksi->prepare($sql_update);
    $stmt->bind_param("i", $id_penjualan);
    if ($stmt->execute()) {
        header("location: view_piutang.php?status=success&message=Piutang berhasil dilunasi.");
    } else {
        $message = "<div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4' role='alert'>Error: " . $stmt->error . "</div>";
    }
    $stmt->close();
}

$penjualan_data = null;
if (isset($_GET['id'])) {
    $id_penjualan = $_GET['id'];
    $sql_get = "SELECT tp.*, mp.nama_pelanggan FROM transaksi_penjualan tp JOIN master_pelanggan mp ON tp.id_pelanggan = mp.id_pelanggan WHERE tp.id_penjualan = ?";
    $stmt = $koneksi->prepare($sql_get);
    $stmt->bind_param("i", $id_penjualan);
    $stmt->execute();
    $result = $stmt->get_result();
    $penjualan_data = $result->fetch_assoc();
    $stmt->close();
    if (!$penjualan_data) {
        $message = "<div class='bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4' role='alert'>Transaksi tidak ditemukan.</div>";
    }
} else {
    header("location: view_piutang.php");
    exit();
}

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pelunasan Piutang - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .form-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .btn { padding: 0.5rem 1rem; border-radius: 8px; transition: all 0.2s ease; font-weight: 600; }
        .btn-green { background-color: #38a169; color: white; }
        .btn-green:hover { background-color: #2f855a; }
        .btn-red { background-color: #e53e3e; color: white; }
        .btn-red:hover { background-color: #c53030; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=master_produk" class="sidebar-item">
                        <i class="fas fa-cube"></i>
                        <span>Master Produk</span>
                    </a>
                    <a href="dashboard.php?page=master_supplier" class="sidebar-item">
                        <i class="fas fa-truck-loading"></i>
                        <span>Master Supplier</span>
                    </a>
                    <a href="dashboard.php?page=master_pelanggan" class="sidebar-item">
                        <i class="fas fa-users"></i>
                        <span>Master Pelanggan</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item active">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">Pelunasan Piutang</h1>
            </header>
            
            <div class="content-area">
                <?php echo $message; ?>
                <?php if ($penjualan_data): ?>
                    <div class="form-container">
                        <h3 class="text-xl font-semibold mb-4">Konfirmasi Pelunasan Piutang</h3>
                        <p class="mb-2"><strong>No. Faktur Jual:</strong> <?php echo htmlspecialchars($penjualan_data['no_faktur_jual']); ?></p>
                        <p class="mb-2"><strong>Tanggal Transaksi:</strong> <?php echo htmlspecialchars($penjualan_data['tgl_transaksi']); ?></p>
                        <p class="mb-2"><strong>Pelanggan:</strong> <?php echo htmlspecialchars($penjualan_data['nama_pelanggan']); ?></p>
                        <p class="mb-2"><strong>Total Piutang:</strong> Rp <?php echo number_format($penjualan_data['harga_total_produk'], 0, ',', '.'); ?></p>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative my-4" role="alert">
                            <p class="font-bold">Peringatan!</p>
                            <p>Tindakan ini akan mengubah status piutang menjadi Lunas.</p>
                        </div>
                        <form action="pelunasan_piutang.php" method="POST">
                            <input type="hidden" name="id_penjualan" value="<?php echo htmlspecialchars($penjualan_data['id_penjualan']); ?>">
                            <div class="mt-6">
                                <button type="submit" name="confirm_payment" class="bg-green-500 text-white px-4 py-2 rounded-lg hover:bg-green-600 transition">Konfirmasi Pelunasan</button>
                                <a href="view_piutang.php" class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 transition ml-2">Batal</a>
                            </div>
                        </form>
                    </div>
                <?php else: ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                        <p class="font-bold">Error!</p>
                        <p>Data transaksi tidak valid atau tidak ditemukan.</p>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</body>
</html>
