<?php
session_start();
include 'koneksi.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Menghindari SQL Injection
    $stmt = $koneksi->prepare("SELECT id_user, username, password, role, nama_lengkap FROM master_user WHERE username = ?");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        
        // Verifikasi password yang di-hash
        if (password_verify($password, $user['password'])) {
            // Login berhasil, buat sesi
            $_SESSION['loggedin'] = true;
            $_SESSION['id_user'] = $user['id_user'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['nama_lengkap'] = $user['nama_lengkap'];
            $_SESSION['role'] = $user['role'];

            // Arahkan ke dashboard setelah login berhasil
            header("location: dashboard.php");
            exit;
        } else {
            // Password salah
            header("location: login.php?error=1");
            exit;
        }
    } else {
        // Username tidak ditemukan
        header("location: login.php?error=1");
        exit;
    }

    $stmt->close();
}
$koneksi->close();
?>
