<?php
session_start();
include 'koneksi.php';

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET['id'])) {
    $id_pembelian = $_GET['id'];

    $koneksi->begin_transaction();

    try {
        // Update status pembayaran di tabel transaksi_pembelian
        $sql_update = "UPDATE transaksi_pembelian SET status_pembayaran = 'Lunas' WHERE id_pembelian = ?";
        $stmt_update = $koneksi->prepare($sql_update);
        $stmt_update->bind_param("i", $id_pembelian);
        $stmt_update->execute();

        // Redirect kembali ke halaman utang dengan status sukses
        $koneksi->commit();
        header("location: dashboard.php?page=utang&status=pelunasan_sukses");
        exit;

    } catch (Exception $e) {
        $koneksi->rollback();
        header("location: dashboard.php?page=utang&status=error&message=" . urlencode("Pelunasan gagal: " . $e->getMessage()));
        exit;
    }
} else {
    // Jika tidak ada ID yang diberikan, redirect kembali ke halaman utang
    header("location: dashboard.php?page=utang");
    exit;
}
?>
