<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $tgl_transaksi = $_POST['tgl_transaksi'];
    $no_faktur_beli = $_POST['no_faktur_beli'];
    $kode_supplier = $_POST['kode_supplier'];
    $status_pembayaran = $_POST['status_pembayaran'];
    $keterangan = $_POST['keterangan'];
    $user_id = $_SESSION['id_user'];
    
    // Arrays for products
    $kode_produk_arr = $_POST['kode_produk'];
    $jumlah_produk_arr = $_POST['jumlah_produk'];
    $satuan_arr = $_POST['satuan'];
    $harga_satuan_arr = $_POST['harga_satuan_produk'];

    // Start a transaction for data integrity
    $koneksi->begin_transaction();

    try {
        // Fetch supplier ID
        $stmt_supplier = $koneksi->prepare("SELECT id_supplier FROM master_supplier WHERE kode_supplier = ?");
        $stmt_supplier->bind_param("s", $kode_supplier);
        $stmt_supplier->execute();
        $result_supplier = $stmt_supplier->get_result();
        if ($result_supplier->num_rows === 0) {
            throw new Exception("Supplier tidak ditemukan.");
        }
        $supplier = $result_supplier->fetch_assoc();
        $id_supplier = $supplier['id_supplier'];
        $stmt_supplier->close();

        // Calculate total purchase amount
        $total_pembelian = 0;
        foreach ($harga_satuan_arr as $index => $harga_satuan) {
            $jumlah = (int)$jumlah_produk_arr[$index];
            $harga = (float)$harga_satuan;
            $total_pembelian += ($jumlah * $harga);
        }

        // Insert into transaksi_pembelian
        $stmt_pembelian = $koneksi->prepare("INSERT INTO transaksi_pembelian (no_faktur_beli, tgl_transaksi, id_supplier, total_pembelian, status_pembayaran, keterangan, id_user) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt_pembelian->bind_param("sssdssi", $no_faktur_beli, $tgl_transaksi, $id_supplier, $total_pembelian, $status_pembayaran, $keterangan, $user_id);
        if (!$stmt_pembelian->execute()) {
            throw new Exception("Gagal menyimpan transaksi pembelian.");
        }
        $id_pembelian = $koneksi->insert_id;
        $stmt_pembelian->close();

        // Insert into transaksi_pembelian_detail
        $stmt_detail = $koneksi->prepare("INSERT INTO transaksi_pembelian_detail (id_pembelian, id_produk, jumlah_produk, satuan, harga_satuan_produk, harga_total_produk) VALUES (?, ?, ?, ?, ?, ?)");

        foreach ($kode_produk_arr as $index => $kode_produk) {
            // Fetch product ID
            $stmt_produk = $koneksi->prepare("SELECT id_produk FROM master_produk WHERE kode_produk = ?");
            $stmt_produk->bind_param("s", $kode_produk);
            $stmt_produk->execute();
            $result_produk = $stmt_produk->get_result();
            if ($result_produk->num_rows === 0) {
                throw new Exception("Produk tidak ditemukan: " . $kode_produk);
            }
            $product = $result_produk->fetch_assoc();
            $id_produk = $product['id_produk'];
            $stmt_produk->close();

            $jumlah = (int)$jumlah_produk_arr[$index];
            $satuan = $satuan_arr[$index];
            $harga_satuan = (float)$harga_satuan_arr[$index];
            $harga_total = $jumlah * $harga_satuan;

            $stmt_detail->bind_param("iisdsd", $id_pembelian, $id_produk, $jumlah, $satuan, $harga_satuan, $harga_total);
            if (!$stmt_detail->execute()) {
                throw new Exception("Gagal menyimpan detail produk untuk " . $kode_produk);
            }
        }
        $stmt_detail->close();

        // Commit transaction
        $koneksi->commit();
        echo "Transaksi pembelian berhasil disimpan.";

    } catch (Exception $e) {
        // Rollback on error
        $koneksi->rollback();
        echo "Error: " . $e->getMessage();
    }
}
$koneksi->close();
?>
