<?php
session_start();
include 'koneksi.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $tgl_transaksi = $_POST['tgl_transaksi'];
    $kode_langganan = $_POST['kode_langganan'];
    $status_pembayaran = $_POST['status_pembayaran'];
    $keterangan = $_POST['keterangan'];

    $kode_produk_arr = $_POST['kode_produk'];
    $jumlah_produk_arr = $_POST['jumlah_produk'];
    $harga_satuan_produk_arr = $_POST['harga_satuan_produk'];
    $harga_total_produk_arr = $_POST['harga_total_produk'];
    $satuan_arr = $_POST['satuan'];

    $koneksi->begin_transaction();

    try {
        // Mendapatkan ID Pelanggan
        $sql_pelanggan_id = "SELECT id_pelanggan FROM master_pelanggan WHERE kode_langganan = ?";
        $stmt_pelanggan = $koneksi->prepare($sql_pelanggan_id);
        $stmt_pelanggan->bind_param("s", $kode_langganan);
        $stmt_pelanggan->execute();
        $result_pelanggan = $stmt_pelanggan->get_result();
        $row_pelanggan = $result_pelanggan->fetch_assoc();
        $id_pelanggan = $row_pelanggan['id_pelanggan'];

        // Mendapatkan nomor faktur jual otomatis (PJ-YYYYMMDD-XXXX)
        $prefix = "PJ-" . date('Ymd') . "-";
        $sql_count = "SELECT COUNT(*) as total FROM transaksi_penjualan WHERE no_faktur_jual LIKE '$prefix%'";
        $result_count = $koneksi->query($sql_count);
        $row_count = $result_count->fetch_assoc();
        $total_transaksi = $row_count['total'] + 1;
        $no_faktur_jual = $prefix . str_pad($total_transaksi, 4, '0', STR_PAD_LEFT);

        // Insert ke tabel transaksi_penjualan
        $sql_penjualan = "INSERT INTO transaksi_penjualan (tgl_transaksi, no_faktur_jual, id_pelanggan, status_pembayaran, keterangan) VALUES (?, ?, ?, ?, ?)";
        $stmt_penjualan = $koneksi->prepare($sql_penjualan);
        $stmt_penjualan->bind_param("ssiss", $tgl_transaksi, $no_faktur_jual, $id_pelanggan, $status_pembayaran, $keterangan);
        $stmt_penjualan->execute();
        $id_penjualan_baru = $koneksi->insert_id;

        // Loop untuk detail produk
        for ($i = 0; $i < count($kode_produk_arr); $i++) {
            $kode_produk = $kode_produk_arr[$i];
            $jumlah_produk = $jumlah_produk_arr[$i];
            $harga_satuan = $harga_satuan_produk_arr[$i];
            $harga_total = $harga_total_produk_arr[$i];
            $satuan = $satuan_arr[$i];

            // Mendapatkan ID Produk dari kode_produk
            $sql_produk_id = "SELECT id_produk FROM master_produk WHERE kode_produk = ?";
            $stmt_produk = $koneksi->prepare($sql_produk_id);
            $stmt_produk->bind_param("s", $kode_produk);
            $stmt_produk->execute();
            $result_produk = $stmt_produk->get_result();
            $row_produk = $result_produk->fetch_assoc();
            $id_produk = $row_produk['id_produk'];

            // Insert ke tabel transaksi_penjualan_detail
            $sql_detail = "INSERT INTO transaksi_penjualan_detail (id_penjualan, id_produk, jumlah_produk, harga_satuan, harga_total_produk, satuan) VALUES (?, ?, ?, ?, ?, ?)";
            $stmt_detail = $koneksi->prepare($sql_detail);
            $stmt_detail->bind_param("iiidds", $id_penjualan_baru, $id_produk, $jumlah_produk, $harga_satuan, $harga_total, $satuan);
            $stmt_detail->execute();

            // Update stok produk
            $sql_stok = "UPDATE master_produk SET stok = stok - ? WHERE id_produk = ?";
            $stmt_stok = $koneksi->prepare($sql_stok);
            $stmt_stok->bind_param("ii", $jumlah_produk, $id_produk);
            $stmt_stok->execute();
        }

        $koneksi->commit();
        header("location: dashboard.php?page=view_penjualan&status=success");
        exit;

    } catch (Exception $e) {
        $koneksi->rollback();
        header("location: dashboard.php?page=input_penjualan&status=error&message=" . urlencode($e->getMessage()));
        exit;
    }
} else {
    header("location: dashboard.php?page=input_penjualan");
    exit;
}
?>
