<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id_supplier = $_POST['id_supplier'];
    $id_produk = $_POST['id_produk'];
    $jumlah_retur = $_POST['jumlah_retur'];
    $keterangan = $_POST['keterangan'];
    $tgl_retur = $_POST['tgl_retur'];

    // Validasi data
    if (empty($id_supplier) || empty($id_produk) || empty($jumlah_retur) || empty($tgl_retur)) {
        header("location: input_retur_pembelian.php?status=error&message=Semua field harus diisi.");
        exit();
    }

    $koneksi->begin_transaction();
    try {
        // Ambil data produk untuk diupdate
        $sql_get_produk = "SELECT stok FROM master_produk WHERE id_produk = ?";
        $stmt_get_produk = $koneksi->prepare($sql_get_produk);
        $stmt_get_produk->bind_param("i", $id_produk);
        $stmt_get_produk->execute();
        $result_produk = $stmt_get_produk->get_result();
        $produk_data = $result_produk->fetch_assoc();
        $stmt_get_produk->close();

        if ($produk_data['stok'] < $jumlah_retur) {
            $koneksi->rollback();
            header("location: input_retur_pembelian.php?status=error&message=Jumlah retur melebihi stok yang tersedia.");
            exit();
        }

        // Update stok produk (kurangi)
        $sql_update_stok = "UPDATE master_produk SET stok = stok - ? WHERE id_produk = ?";
        $stmt_update_stok = $koneksi->prepare($sql_update_stok);
        $stmt_update_stok->bind_param("ii", $jumlah_retur, $id_produk);
        $stmt_update_stok->execute();
        $stmt_update_stok->close();

        // Generate no_retur_beli
        $no_retur_beli = "RTB-" . date("YmdHis") . "-" . mt_rand(100, 999);

        // Insert data ke tabel retur_pembelian
        $sql_insert = "INSERT INTO retur_pembelian (no_retur_beli, tgl_retur, id_supplier, id_produk, jumlah_retur, keterangan) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt_insert = $koneksi->prepare($sql_insert);
        $stmt_insert->bind_param("ssiiis", $no_retur_beli, $tgl_retur, $id_supplier, $id_produk, $jumlah_retur, $keterangan);
        $stmt_insert->execute();
        $stmt_insert->close();

        $koneksi->commit();
        header("location: input_retur_pembelian.php?status=success&message=Retur pembelian berhasil disimpan.");
    } catch (Exception $e) {
        $koneksi->rollback();
        header("location: input_retur_pembelian.php?status=error&message=Terjadi kesalahan: " . $e->getMessage());
    }
} else {
    header("location: input_retur_pembelian.php");
}

$koneksi->close();
?>
