<?php
session_start();
include 'koneksi.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $tgl_retur = $_POST['tgl_retur'];
    $no_retur = $_POST['no_retur'];
    $no_faktur_jual = $_POST['no_faktur_jual'];
    $kode_produk = $_POST['kode_produk'];
    $jumlah_retur = $_POST['jumlah_retur'];
    $alasan_retur = $_POST['alasan_retur'];

    $koneksi->begin_transaction();

    try {
        // Mendapatkan ID Produk
        $sql_produk_id = "SELECT id_produk FROM master_produk WHERE kode_produk = ?";
        $stmt_produk = $koneksi->prepare($sql_produk_id);
        $stmt_produk->bind_param("s", $kode_produk);
        $stmt_produk->execute();
        $result_produk = $stmt_produk->get_result();
        $row_produk = $result_produk->fetch_assoc();
        $id_produk = $row_produk['id_produk'];

        // Mendapatkan ID Penjualan dari no_faktur_jual
        $sql_penjualan_id = "SELECT id_penjualan FROM transaksi_penjualan WHERE no_faktur_jual = ?";
        $stmt_penjualan = $koneksi->prepare($sql_penjualan_id);
        $stmt_penjualan->bind_param("s", $no_faktur_jual);
        $stmt_penjualan->execute();
        $result_penjualan = $stmt_penjualan->get_result();
        $row_penjualan = $result_penjualan->fetch_assoc();
        $id_penjualan = $row_penjualan['id_penjualan'];

        // Insert ke tabel retur_penjualan
        $sql_insert = "INSERT INTO retur_penjualan (tgl_retur, no_retur, id_penjualan, id_produk, jumlah_retur, alasan_retur) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt_insert = $koneksi->prepare($sql_insert);
        $stmt_insert->bind_param("ssiiis", $tgl_retur, $no_retur, $id_penjualan, $id_produk, $jumlah_retur, $alasan_retur);
        $stmt_insert->execute();

        // Update stok produk (stok bertambah)
        $sql_update_stok = "UPDATE master_produk SET stok = stok + ? WHERE id_produk = ?";
        $stmt_update_stok = $koneksi->prepare($sql_update_stok);
        $stmt_update_stok->bind_param("ii", $jumlah_retur, $id_produk);
        $stmt_update_stok->execute();
        
        // Catat histori stok (Retur Penjualan)
        $tipe_stok = "Masuk";
        $keterangan_histori = "Retur Penjualan";
        $sql_histori = "INSERT INTO stok_history (id_produk, jumlah, tipe, keterangan, dokumen_ref) VALUES (?, ?, ?, ?, ?)";
        $stmt_histori = $koneksi->prepare($sql_histori);
        $stmt_histori->bind_param("iisss", $id_produk, $jumlah_retur, $tipe_stok, $keterangan_histori, $no_retur);
        $stmt_histori->execute();

        $koneksi->commit();
        header("location: dashboard.php?page=retur_penjualan&status=success");
        exit;

    } catch (Exception $e) {
        $koneksi->rollback();
        header("location: dashboard.php?page=input_retur_penjualan&status=error&message=" . urlencode($e->getMessage()));
        exit;
    }
} else {
    header("location: dashboard.php?page=input_retur_penjualan");
    exit;
}
?>
