<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];

// Ambil data pelanggan dan produk untuk dropdown filter
$customers = $koneksi->query("SELECT nama_pelanggan FROM master_pelanggan ORDER BY nama_pelanggan")->fetch_all(MYSQLI_ASSOC);
$products = $koneksi->query("SELECT nama_produk, type_produk, merk_produk, kategori_produk FROM master_produk ORDER BY nama_produk")->fetch_all(MYSQLI_ASSOC);

// Base query for sales
$sql = "SELECT tj.no_faktur_jual, tj.tgl_transaksi, mp.nama_pelanggan, tj.total_penjualan, tj.status_pembayaran, tj.keterangan
        FROM transaksi_penjualan tj
        JOIN master_pelanggan mp ON tj.id_pelanggan = mp.id_pelanggan
        WHERE 1=1";
$params = [];
$types = '';

// Handling filters
if (isset($_GET['filter_faktur']) && !empty($_GET['filter_faktur'])) {
    $sql .= " AND tj.no_faktur_jual LIKE ?";
    $params[] = '%' . $_GET['filter_faktur'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_tanggal']) && !empty($_GET['filter_tanggal'])) {
    $sql .= " AND tj.tgl_transaksi = ?";
    $params[] = $_GET['filter_tanggal'];
    $types .= 's';
}
if (isset($_GET['filter_pelanggan']) && !empty($_GET['filter_pelanggan'])) {
    $sql .= " AND mp.nama_pelanggan LIKE ?";
    $params[] = '%' . $_GET['filter_pelanggan'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_produk']) && !empty($_GET['filter_produk'])) {
    $sql .= " AND EXISTS (SELECT 1 FROM transaksi_penjualan_detail tjd JOIN master_produk mp ON tjd.id_produk = mp.id_produk WHERE tjd.id_penjualan = tj.id_penjualan AND mp.nama_produk LIKE ?)";
    $params[] = '%' . $_GET['filter_produk'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_status']) && !empty($_GET['filter_status'])) {
    $sql .= " AND tj.status_pembayaran = ?";
    $params[] = $_GET['filter_status'];
    $types .= 's';
}
if (isset($_GET['filter_keterangan']) && !empty($_GET['filter_keterangan'])) {
    $sql .= " AND tj.keterangan LIKE ?";
    $params[] = '%' . $_GET['filter_keterangan'] . '%';
    $types .= 's';
}

$sql .= " ORDER BY tj.tgl_transaksi DESC, tj.no_faktur_jual DESC";
$stmt = $koneksi->prepare($sql);
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result_penjualan = $stmt->get_result();

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Penjualan - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .filter-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item active">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">View Penjualan</h1>
            </header>
            
            <div class="content-area">
                <div class="filter-container mb-6">
                    <h3 class="text-xl font-semibold mb-4">Filter Transaksi</h3>
                    <form action="view_penjualan.php" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div class="input-group">
                                <label for="filter_faktur" class="block text-gray-700">No. Faktur Jual</label>
                                <input type="text" id="filter_faktur" name="filter_faktur" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_faktur'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_tanggal" class="block text-gray-700">Tanggal Transaksi</label>
                                <input type="date" id="filter_tanggal" name="filter_tanggal" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_tanggal'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_pelanggan" class="block text-gray-700">Nama Pelanggan</label>
                                <select id="filter_pelanggan" name="filter_pelanggan" class="mt-1 block w-full">
                                    <option value="">-- Semua Pelanggan --</option>
                                    <?php foreach ($customers as $customer): ?>
                                        <option value="<?php echo htmlspecialchars($customer['nama_pelanggan']); ?>" <?php echo (isset($_GET['filter_pelanggan']) && $_GET['filter_pelanggan'] == $customer['nama_pelanggan']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($customer['nama_pelanggan']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_produk" class="block text-gray-700">Nama Produk</label>
                                <select id="filter_produk" name="filter_produk" class="mt-1 block w-full">
                                    <option value="">-- Semua Produk --</option>
                                    <?php foreach ($products as $product): ?>
                                        <option value="<?php echo htmlspecialchars($product['nama_produk']); ?>" <?php echo (isset($_GET['filter_produk']) && $_GET['filter_produk'] == $product['nama_produk']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($product['nama_produk']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_status" class="block text-gray-700">Status Pembayaran</label>
                                <select id="filter_status" name="filter_status" class="mt-1 block w-full">
                                    <option value="">-- Semua Status --</option>
                                    <option value="Lunas" <?php echo (isset($_GET['filter_status']) && $_GET['filter_status'] == 'Lunas') ? 'selected' : ''; ?>>Lunas</option>
                                    <option value="Belum Lunas" <?php echo (isset($_GET['filter_status']) && $_GET['filter_status'] == 'Belum Lunas') ? 'selected' : ''; ?>>Belum Lunas</option>
                                </select>
                            </div>
                            <div class="input-group">
                                <label for="filter_keterangan" class="block text-gray-700">Keterangan</label>
                                <input type="text" id="filter_keterangan" name="filter_keterangan" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_keterangan'] ?? ''); ?>">
                            </div>
                            <div class="flex items-end space-x-2 mt-4">
                                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition">Filter</button>
                                <a href="view_penjualan.php" class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 transition">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="table-container">
                    <h3 class="text-xl font-semibold mb-4">Daftar Transaksi Penjualan</h3>
                    <div class="table-responsive rounded-lg shadow-sm">
                        <table class="table-auto min-w-full bg-white rounded-lg">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3">No. Faktur</th>
                                    <th class="px-6 py-3">Tanggal</th>
                                    <th class="px-6 py-3">Pelanggan</th>
                                    <th class="px-6 py-3">Total</th>
                                    <th class="px-6 py-3">Status Bayar</th>
                                    <th class="px-6 py-3">Keterangan</th>
                                    <th class="px-6 py-3">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result_penjualan->num_rows > 0): ?>
                                    <?php while($row = $result_penjualan->fetch_assoc()): ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['no_faktur_jual']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['tgl_transaksi']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_pelanggan']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['total_penjualan'], 2, ',', '.'); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo ($row['status_pembayaran'] == 'Lunas') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                                                <?php echo htmlspecialchars($row['status_pembayaran']); ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-sm text-gray-500"><?php echo htmlspecialchars($row['keterangan']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <a href="cetak_faktur_jual.php?no_faktur=<?php echo urlencode($row['no_faktur_jual']); ?>" class="text-blue-600 hover:text-blue-900 mr-4">
                                                <i class="fas fa-print"></i> Cetak
                                            </a>
                                            <a href="#" class="text-red-600 hover:text-red-900">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center text-gray-500">Tidak ada data penjualan yang ditemukan.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
