<?php
session_start();
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("location: login.php");
    exit;
}
include 'koneksi.php';

$user_role = $_SESSION['role'];

$sql = "SELECT kode_produk, nama_produk, type_produk, merk_produk, kategori_produk, harga_beli, harga_jual, stok FROM master_produk WHERE 1=1";
$params = [];
$types = '';

// Handling filters
if (isset($_GET['filter_kode']) && !empty($_GET['filter_kode'])) {
    $sql .= " AND kode_produk LIKE ?";
    $params[] = '%' . $_GET['filter_kode'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_nama']) && !empty($_GET['filter_nama'])) {
    $sql .= " AND nama_produk LIKE ?";
    $params[] = '%' . $_GET['filter_nama'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_type']) && !empty($_GET['filter_type'])) {
    $sql .= " AND type_produk LIKE ?";
    $params[] = '%' . $_GET['filter_type'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_merk']) && !empty($_GET['filter_merk'])) {
    $sql .= " AND merk_produk LIKE ?";
    $params[] = '%' . $_GET['filter_merk'] . '%';
    $types .= 's';
}
if (isset($_GET['filter_kategori']) && !empty($_GET['filter_kategori'])) {
    $sql .= " AND kategori_produk LIKE ?";
    $params[] = '%' . $_GET['filter_kategori'] . '%';
    $types .= 's';
}
if (isset($_GET['sort']) && in_array($_GET['sort'], ['nama_produk', 'kode_produk', 'stok_desc', 'stok_asc'])) {
    if ($_GET['sort'] == 'stok_desc') {
        $sql .= " ORDER BY stok DESC";
    } elseif ($_GET['sort'] == 'stok_asc') {
        $sql .= " ORDER BY stok ASC";
    } else {
        $sql .= " ORDER BY " . $_GET['sort'];
    }
} else {
    $sql .= " ORDER BY nama_produk";
}

$stmt = $koneksi->prepare($sql);
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result_stok = $stmt->get_result();

$koneksi->close();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Stok - Sistem Informasi Bisnis</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .sidebar { background-color: #ffffff; box-shadow: 2px 0 10px rgba(0,0,0,0.05); }
        .sidebar-item { display: flex; align-items: center; padding: 1rem 1.5rem; color: #666; transition: all 0.2s ease; border-radius: 10px; margin: 0.5rem 1rem; }
        .sidebar-item:hover, .sidebar-item.active { background-color: #e2e8f0; color: #2c5282; transform: translateX(5px); }
        .sidebar-item i { font-size: 1.25rem; width: 25px; text-align: center; }
        .sidebar-item span { margin-left: 1rem; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .logo { padding: 1rem; text-align: center; font-size: 1.5rem; font-weight: 700; color: #333; }
        .content-area { background-color: #f9fafb; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
        .filter-container { background-color: #ffffff; padding: 2rem; border-radius: 15px; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
        .input-group label { font-weight: 600; }
        .input-group input, .input-group select, .input-group textarea { border-radius: 10px; border-color: #e2e8f0; padding: 0.75rem 1rem; width: 100%; transition: all 0.2s ease; }
        .input-group input:focus, .input-group select:focus, .input-group textarea:focus { outline: none; border-color: #5d9cec; box-shadow: 0 0 0 3px rgba(93, 156, 236, 0.2); }
        .table-responsive { overflow-x: auto; }
        .table-auto { width: 100%; border-collapse: collapse; }
        .table-auto th, .table-auto td { padding: 1rem; text-align: left; border-bottom: 1px solid #e2e8f0; }
        .table-auto th { background-color: #f7f9fc; font-weight: 600; text-transform: uppercase; }
    </style>
</head>
<body>
    <div class="flex min-h-screen">
        <aside class="sidebar w-64 p-4 flex flex-col justify-between">
            <div>
                <div class="logo">App Bisnis</div>
                <nav class="mt-8">
                    <a href="dashboard.php" class="sidebar-item">
                        <i class="fas fa-home"></i>
                        <span>Dashboard</span>
                    </a>
                    <a href="dashboard.php?page=pembelian" class="sidebar-item">
                        <i class="fas fa-shopping-cart"></i>
                        <span>Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=penjualan" class="sidebar-item">
                        <i class="fas fa-cash-register"></i>
                        <span>Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=stok" class="sidebar-item active">
                        <i class="fas fa-box-open"></i>
                        <span>Stok</span>
                    </a>
                    <a href="dashboard.php?page=retur_pembelian" class="sidebar-item">
                        <i class="fas fa-undo"></i>
                        <span>Retur Pembelian</span>
                    </a>
                    <a href="dashboard.php?page=retur_penjualan" class="sidebar-item">
                        <i class="fas fa-undo-alt"></i>
                        <span>Retur Penjualan</span>
                    </a>
                    <a href="dashboard.php?page=utang" class="sidebar-item">
                        <i class="fas fa-hand-holding-usd"></i>
                        <span>Utang</span>
                    </a>
                    <a href="dashboard.php?page=piutang" class="sidebar-item">
                        <i class="fas fa-money-check-alt"></i>
                        <span>Piutang</span>
                    </a>
                    <a href="dashboard.php?page=kas_harian" class="sidebar-item">
                        <i class="fas fa-wallet"></i>
                        <span>Kas Harian</span>
                    </a>
                    <?php if ($user_role == 'admin'): ?>
                        <a href="dashboard.php?page=laba_kotor" class="sidebar-item">
                            <i class="fas fa-chart-line"></i>
                            <span>Laba Kotor</span>
                        </a>
                    <?php endif; ?>
                    <a href="dashboard.php?page=dss" class="sidebar-item">
                        <i class="fas fa-chart-pie"></i>
                        <span>DSS</span>
                    </a>
                </nav>
            </div>
            <div class="mb-4">
                <a href="logout.php" class="sidebar-item text-red-500 hover:bg-red-100">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </aside>

        <main class="flex-1 p-8">
            <header class="flex justify-between items-center mb-6">
                <h1 class="text-3xl font-bold text-gray-800">View Stok Produk</h1>
            </header>
            
            <div class="content-area">
                <div class="filter-container mb-6">
                    <h3 class="text-xl font-semibold mb-4">Filter & Urutkan Stok</h3>
                    <form action="view_stok.php" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                            <div class="input-group">
                                <label for="filter_kode" class="block text-gray-700">Kode Produk</label>
                                <input type="text" id="filter_kode" name="filter_kode" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_kode'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_nama" class="block text-gray-700">Nama Produk</label>
                                <input type="text" id="filter_nama" name="filter_nama" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_nama'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_type" class="block text-gray-700">Type Produk</label>
                                <input type="text" id="filter_type" name="filter_type" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_type'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_merk" class="block text-gray-700">Merk Produk</label>
                                <input type="text" id="filter_merk" name="filter_merk" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_merk'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="filter_kategori" class="block text-gray-700">Kategori Produk</label>
                                <input type="text" id="filter_kategori" name="filter_kategori" class="mt-1 block w-full" value="<?php echo htmlspecialchars($_GET['filter_kategori'] ?? ''); ?>">
                            </div>
                            <div class="input-group">
                                <label for="sort" class="block text-gray-700">Urutkan Berdasarkan</label>
                                <select id="sort" name="sort" class="mt-1 block w-full">
                                    <option value="nama_produk" <?php echo (isset($_GET['sort']) && $_GET['sort'] == 'nama_produk') ? 'selected' : ''; ?>>Nama Produk</option>
                                    <option value="kode_produk" <?php echo (isset($_GET['sort']) && $_GET['sort'] == 'kode_produk') ? 'selected' : ''; ?>>Kode Produk</option>
                                    <option value="stok_desc" <?php echo (isset($_GET['sort']) && $_GET['sort'] == 'stok_desc') ? 'selected' : ''; ?>>Stok Terbanyak</option>
                                    <option value="stok_asc" <?php echo (isset($_GET['sort']) && $_GET['sort'] == 'stok_asc') ? 'selected' : ''; ?>>Stok Tersedikit</option>
                                </select>
                            </div>
                            <div class="flex items-end space-x-2 mt-4">
                                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition">Filter</button>
                                <a href="view_stok.php" class="bg-gray-300 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-400 transition">Reset</a>
                            </div>
                        </div>
                    </form>
                </div>

                <div class="table-container">
                    <h3 class="text-xl font-semibold mb-4">Daftar Stok Saat Ini</h3>
                    <div class="table-responsive rounded-lg shadow-sm">
                        <table class="table-auto min-w-full bg-white rounded-lg">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3">Kode Produk</th>
                                    <th class="px-6 py-3">Nama Produk</th>
                                    <th class="px-6 py-3">Type</th>
                                    <th class="px-6 py-3">Merk</th>
                                    <th class="px-6 py-3">Kategori</th>
                                    <th class="px-6 py-3">Harga Beli</th>
                                    <th class="px-6 py-3">Harga Jual</th>
                                    <th class="px-6 py-3">Stok</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($result_stok->num_rows > 0): ?>
                                    <?php while($row = $result_stok->fetch_assoc()): ?>
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo htmlspecialchars($row['kode_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['nama_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['type_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['merk_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo htmlspecialchars($row['kategori_produk']); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['harga_beli'], 2, ',', '.'); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?php echo number_format($row['harga_jual'], 2, ',', '.'); ?></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-gray-900"><?php echo htmlspecialchars($row['stok']); ?></td>
                                    </tr>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="8" class="px-6 py-4 text-center text-gray-500">Tidak ada data stok yang ditemukan.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>
</html>
